// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



/**
 * An object that defines the Key element of a ProfileObject. A Key is a special element that can be used to search for a customer profile.
 */
class ObjectTypeKey private constructor(builder: Builder) {
    /**
     * The reference for the key name of the fields map.
     */
    val fieldNames: List<String>? = builder.fieldNames
    /**
     * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple PROFILE keys. PROFILE, ASSET, CASE, or ORDER means that this key can be used to tie an object to a PROFILE, ASSET, CASE, or ORDER respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it is only used for matching objects to profiles.
     */
    val standardIdentifiers: List<StandardIdentifier>? = builder.standardIdentifiers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectTypeKey(")
        append("fieldNames=$fieldNames,")
        append("standardIdentifiers=$standardIdentifiers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldNames?.hashCode() ?: 0
        result = 31 * result + (standardIdentifiers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectTypeKey

        if (fieldNames != other.fieldNames) return false
        if (standardIdentifiers != other.standardIdentifiers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey = Builder(this).apply(block).build()

    class Builder {
        /**
         * The reference for the key name of the fields map.
         */
        var fieldNames: List<String>? = null
        /**
         * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple PROFILE keys. PROFILE, ASSET, CASE, or ORDER means that this key can be used to tie an object to a PROFILE, ASSET, CASE, or ORDER respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it is only used for matching objects to profiles.
         */
        var standardIdentifiers: List<StandardIdentifier>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey) : this() {
            this.fieldNames = x.fieldNames
            this.standardIdentifiers = x.standardIdentifiers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey = ObjectTypeKey(this)
    }
}
