// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.time.Instant

class GetDomainResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the domain was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     */
    val deadLetterQueueUrl: kotlin.String? = builder.deadLetterQueueUrl
    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    val defaultEncryptionKey: kotlin.String? = builder.defaultEncryptionKey
    /**
     * The default number of days until the data within the domain expires.
     */
    val defaultExpirationDays: kotlin.Int? = builder.defaultExpirationDays
    /**
     * The unique name of the domain.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * The timestamp of when the domain was most recently edited.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     */
    val matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse? = builder.matching
    /**
     * Usage-specific statistics about the domain.
     */
    val stats: aws.sdk.kotlin.services.customerprofiles.model.DomainStats? = builder.stats
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.GetDomainResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDomainResponse(")
        append("createdAt=$createdAt,")
        append("deadLetterQueueUrl=$deadLetterQueueUrl,")
        append("defaultEncryptionKey=$defaultEncryptionKey,")
        append("defaultExpirationDays=$defaultExpirationDays,")
        append("domainName=$domainName,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("matching=$matching,")
        append("stats=$stats,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (deadLetterQueueUrl?.hashCode() ?: 0)
        result = 31 * result + (defaultEncryptionKey?.hashCode() ?: 0)
        result = 31 * result + (defaultExpirationDays ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (matching?.hashCode() ?: 0)
        result = 31 * result + (stats?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDomainResponse

        if (createdAt != other.createdAt) return false
        if (deadLetterQueueUrl != other.deadLetterQueueUrl) return false
        if (defaultEncryptionKey != other.defaultEncryptionKey) return false
        if (defaultExpirationDays != other.defaultExpirationDays) return false
        if (domainName != other.domainName) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (matching != other.matching) return false
        if (stats != other.stats) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.GetDomainResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The timestamp of when the domain was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
         */
        var deadLetterQueueUrl: kotlin.String? = null
        /**
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         */
        var defaultEncryptionKey: kotlin.String? = null
        /**
         * The default number of days until the data within the domain expires.
         */
        var defaultExpirationDays: kotlin.Int? = null
        /**
         * The unique name of the domain.
         */
        var domainName: kotlin.String? = null
        /**
         * The timestamp of when the domain was most recently edited.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
         *
         * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
         */
        var matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse? = null
        /**
         * Usage-specific statistics about the domain.
         */
        var stats: aws.sdk.kotlin.services.customerprofiles.model.DomainStats? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.GetDomainResponse) : this() {
            this.createdAt = x.createdAt
            this.deadLetterQueueUrl = x.deadLetterQueueUrl
            this.defaultEncryptionKey = x.defaultEncryptionKey
            this.defaultExpirationDays = x.defaultExpirationDays
            this.domainName = x.domainName
            this.lastUpdatedAt = x.lastUpdatedAt
            this.matching = x.matching
            this.stats = x.stats
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.GetDomainResponse = GetDomainResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse] inside the given [block]
         */
        fun matching(block: aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse.Builder.() -> kotlin.Unit) {
            this.matching = aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.DomainStats] inside the given [block]
         */
        fun stats(block: aws.sdk.kotlin.services.customerprofiles.model.DomainStats.Builder.() -> kotlin.Unit) {
            this.stats = aws.sdk.kotlin.services.customerprofiles.model.DomainStats.invoke(block)
        }
    }
}
