// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



/**
 * The configurations that control how Customer Profiles retrieves data from the source, Amazon AppFlow. Customer Profiles uses this information to create an AppFlow flow on behalf of customers.
 */
class FlowDefinition private constructor(builder: Builder) {
    /**
     * A description of the flow you want to create.
     */
    val description: kotlin.String? = builder.description
    /**
     * The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
     */
    val flowName: kotlin.String? = builder.flowName
    /**
     * The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
     */
    val kmsArn: kotlin.String? = builder.kmsArn
    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     */
    val sourceFlowConfig: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig? = builder.sourceFlowConfig
    /**
     * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
     */
    val tasks: List<Task>? = builder.tasks
    /**
     * The trigger settings that determine how and when the flow runs.
     */
    val triggerConfig: aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig? = builder.triggerConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowDefinition(")
        append("description=$description,")
        append("flowName=$flowName,")
        append("kmsArn=$kmsArn,")
        append("sourceFlowConfig=$sourceFlowConfig,")
        append("tasks=$tasks,")
        append("triggerConfig=$triggerConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (flowName?.hashCode() ?: 0)
        result = 31 * result + (kmsArn?.hashCode() ?: 0)
        result = 31 * result + (sourceFlowConfig?.hashCode() ?: 0)
        result = 31 * result + (tasks?.hashCode() ?: 0)
        result = 31 * result + (triggerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowDefinition

        if (description != other.description) return false
        if (flowName != other.flowName) return false
        if (kmsArn != other.kmsArn) return false
        if (sourceFlowConfig != other.sourceFlowConfig) return false
        if (tasks != other.tasks) return false
        if (triggerConfig != other.triggerConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description of the flow you want to create.
         */
        var description: kotlin.String? = null
        /**
         * The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
         */
        var flowName: kotlin.String? = null
        /**
         * The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
         */
        var kmsArn: kotlin.String? = null
        /**
         * The configuration that controls how Customer Profiles retrieves data from the source.
         */
        var sourceFlowConfig: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig? = null
        /**
         * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         */
        var tasks: List<Task>? = null
        /**
         * The trigger settings that determine how and when the flow runs.
         */
        var triggerConfig: aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition) : this() {
            this.description = x.description
            this.flowName = x.flowName
            this.kmsArn = x.kmsArn
            this.sourceFlowConfig = x.sourceFlowConfig
            this.tasks = x.tasks
            this.triggerConfig = x.triggerConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition = FlowDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig] inside the given [block]
         */
        fun sourceFlowConfig(block: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig.Builder.() -> kotlin.Unit) {
            this.sourceFlowConfig = aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig] inside the given [block]
         */
        fun triggerConfig(block: aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig.Builder.() -> kotlin.Unit) {
            this.triggerConfig = aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig.invoke(block)
        }
    }
}
