// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.customerprofiles.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.customerprofiles.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Connect Customer Profiles
 * Welcome to the Amazon Connect Customer Profiles API Reference. This guide provides information about the Amazon Connect Customer Profiles API, including supported operations, data types, parameters, and schemas.
 *
 * Amazon Connect Customer Profiles is a unified customer profile for your contact center that has pre-built connectors powered by AppFlow that make it easy to combine customer information from third party applications, such as Salesforce (CRM), ServiceNow (ITSM), and your enterprise resource planning (ERP), with contact history from your Amazon Connect contact center.
 *
 * If you're new to Amazon Connect , you might find it helpful to also review the [Amazon Connect Administrator Guide](https://docs.aws.amazon.com/connect/latest/adminguide/what-is-amazon-connect.html).
 */
interface CustomerProfilesClient : SdkClient {

    override val serviceName: String
        get() = "Customer Profiles"
    /**
     * CustomerProfilesClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CustomerProfilesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCustomerProfilesClient(config)
        }

        operator fun invoke(config: Config): CustomerProfilesClient = DefaultCustomerProfilesClient(config)

        /**
         * Construct a [CustomerProfilesClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CustomerProfilesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCustomerProfilesClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a new key value with a specific profile, such as a Contact Trace Record (CTR) ContactId.
     *
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the profile that it belongs to.
     */
    suspend fun addProfileKey(input: AddProfileKeyRequest): AddProfileKeyResponse

    /**
     * Associates a new key value with a specific profile, such as a Contact Trace Record (CTR) ContactId.
     *
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the profile that it belongs to.
     */
    suspend fun addProfileKey(block: AddProfileKeyRequest.Builder.() -> Unit) = addProfileKey(AddProfileKeyRequest.Builder().apply(block).build())

    /**
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.
     *
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.
     *
     * Use this API or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
     *
     * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
     */
    suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.
     *
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.
     *
     * Use this API or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
     *
     * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
     */
    suspend fun createDomain(block: CreateDomainRequest.Builder.() -> Unit) = createDomain(CreateDomainRequest.Builder().apply(block).build())

    /**
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
     */
    suspend fun createIntegrationWorkflow(input: CreateIntegrationWorkflowRequest): CreateIntegrationWorkflowResponse

    /**
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
     */
    suspend fun createIntegrationWorkflow(block: CreateIntegrationWorkflowRequest.Builder.() -> Unit) = createIntegrationWorkflow(CreateIntegrationWorkflowRequest.Builder().apply(block).build())

    /**
     * Creates a standard profile.
     *
     * A standard profile represents the following attributes for a customer profile in a domain.
     */
    suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Creates a standard profile.
     *
     * A standard profile represents the following attributes for a customer profile in a domain.
     */
    suspend fun createProfile(block: CreateProfileRequest.Builder.() -> Unit) = createProfile(CreateProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.
     */
    suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.
     */
    suspend fun deleteDomain(block: DeleteDomainRequest.Builder.() -> Unit) = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

    /**
     * Removes an integration from a specific domain.
     */
    suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse

    /**
     * Removes an integration from a specific domain.
     */
    suspend fun deleteIntegration(block: DeleteIntegrationRequest.Builder.() -> Unit) = deleteIntegration(DeleteIntegrationRequest.Builder().apply(block).build())

    /**
     * Deletes the standard customer profile and all data pertaining to the profile.
     */
    suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Deletes the standard customer profile and all data pertaining to the profile.
     */
    suspend fun deleteProfile(block: DeleteProfileRequest.Builder.() -> Unit) = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

    /**
     * Removes a searchable key from a customer profile.
     */
    suspend fun deleteProfileKey(input: DeleteProfileKeyRequest): DeleteProfileKeyResponse

    /**
     * Removes a searchable key from a customer profile.
     */
    suspend fun deleteProfileKey(block: DeleteProfileKeyRequest.Builder.() -> Unit) = deleteProfileKey(DeleteProfileKeyRequest.Builder().apply(block).build())

    /**
     * Removes an object associated with a profile of a given ProfileObjectType.
     */
    suspend fun deleteProfileObject(input: DeleteProfileObjectRequest): DeleteProfileObjectResponse

    /**
     * Removes an object associated with a profile of a given ProfileObjectType.
     */
    suspend fun deleteProfileObject(block: DeleteProfileObjectRequest.Builder.() -> Unit) = deleteProfileObject(DeleteProfileObjectRequest.Builder().apply(block).build())

    /**
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.
     */
    suspend fun deleteProfileObjectType(input: DeleteProfileObjectTypeRequest): DeleteProfileObjectTypeResponse

    /**
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.
     */
    suspend fun deleteProfileObjectType(block: DeleteProfileObjectTypeRequest.Builder.() -> Unit) = deleteProfileObjectType(DeleteProfileObjectTypeRequest.Builder().apply(block).build())

    /**
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     */
    suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     */
    suspend fun deleteWorkflow(block: DeleteWorkflowRequest.Builder.() -> Unit) = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

    /**
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list.
     *
     * You can't view which profiles are matched and would be merged.
     *
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity Resolution Job. Include **at least** two matching attributes. If your matching list includes too few attributes (such as only `FirstName` or only `LastName`), there may be a large number of matches. This increases the chances of erroneous merges.
     */
    suspend fun getAutoMergingPreview(input: GetAutoMergingPreviewRequest): GetAutoMergingPreviewResponse

    /**
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list.
     *
     * You can't view which profiles are matched and would be merged.
     *
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity Resolution Job. Include **at least** two matching attributes. If your matching list includes too few attributes (such as only `FirstName` or only `LastName`), there may be a large number of matches. This increases the chances of erroneous merges.
     */
    suspend fun getAutoMergingPreview(block: GetAutoMergingPreviewRequest.Builder.() -> Unit) = getAutoMergingPreview(GetAutoMergingPreviewRequest.Builder().apply(block).build())

    /**
     * Returns information about a specific domain.
     */
    suspend fun getDomain(input: GetDomainRequest): GetDomainResponse

    /**
     * Returns information about a specific domain.
     */
    suspend fun getDomain(block: GetDomainRequest.Builder.() -> Unit) = getDomain(GetDomainRequest.Builder().apply(block).build())

    /**
     * Returns information about an Identity Resolution Job in a specific domain.
     *
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see [Use Identity Resolution to consolidate similar profiles](https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html).
     */
    suspend fun getIdentityResolutionJob(input: GetIdentityResolutionJobRequest): GetIdentityResolutionJobResponse

    /**
     * Returns information about an Identity Resolution Job in a specific domain.
     *
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see [Use Identity Resolution to consolidate similar profiles](https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html).
     */
    suspend fun getIdentityResolutionJob(block: GetIdentityResolutionJobRequest.Builder.() -> Unit) = getIdentityResolutionJob(GetIdentityResolutionJobRequest.Builder().apply(block).build())

    /**
     * Returns an integration for a domain.
     */
    suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse

    /**
     * Returns an integration for a domain.
     */
    suspend fun getIntegration(block: GetIntegrationRequest.Builder.() -> Unit) = getIntegration(GetIntegrationRequest.Builder().apply(block).build())

    /**
     * Before calling this API, use [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable identity resolution: set `Matching` to true.
     *
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning process.
     *
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     *
     * Amazon Connect uses the following profile attributes to identify matches:
     * + PhoneNumber
     * + HomePhoneNumber
     * + BusinessPhoneNumber
     * + MobilePhoneNumber
     * + EmailAddress
     * + PersonalEmailAddress
     * + BusinessEmailAddress
     * + FullName
     *
     * For example, two or more profiles—with spelling mistakes such as **John Doe** and **Jhn Doe**, or different casing email addresses such as **JOHN_DOE@ANYCOMPANY.COM** and **johndoe@anycompany.com**, or different phone number formats such as **555-010-0000** and **+1-555-010-0000**—can be detected as belonging to the same customer **John Doe** and merged into a unified profile.
     */
    suspend fun getMatches(input: GetMatchesRequest): GetMatchesResponse

    /**
     * Before calling this API, use [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable identity resolution: set `Matching` to true.
     *
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning process.
     *
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     *
     * Amazon Connect uses the following profile attributes to identify matches:
     * + PhoneNumber
     * + HomePhoneNumber
     * + BusinessPhoneNumber
     * + MobilePhoneNumber
     * + EmailAddress
     * + PersonalEmailAddress
     * + BusinessEmailAddress
     * + FullName
     *
     * For example, two or more profiles—with spelling mistakes such as **John Doe** and **Jhn Doe**, or different casing email addresses such as **JOHN_DOE@ANYCOMPANY.COM** and **johndoe@anycompany.com**, or different phone number formats such as **555-010-0000** and **+1-555-010-0000**—can be detected as belonging to the same customer **John Doe** and merged into a unified profile.
     */
    suspend fun getMatches(block: GetMatchesRequest.Builder.() -> Unit) = getMatches(GetMatchesRequest.Builder().apply(block).build())

    /**
     * Returns the object types for a specific domain.
     */
    suspend fun getProfileObjectType(input: GetProfileObjectTypeRequest): GetProfileObjectTypeResponse

    /**
     * Returns the object types for a specific domain.
     */
    suspend fun getProfileObjectType(block: GetProfileObjectTypeRequest.Builder.() -> Unit) = getProfileObjectType(GetProfileObjectTypeRequest.Builder().apply(block).build())

    /**
     * Returns the template information for a specific object type.
     *
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds, it uses the mappings from the template.
     */
    suspend fun getProfileObjectTypeTemplate(input: GetProfileObjectTypeTemplateRequest): GetProfileObjectTypeTemplateResponse

    /**
     * Returns the template information for a specific object type.
     *
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds, it uses the mappings from the template.
     */
    suspend fun getProfileObjectTypeTemplate(block: GetProfileObjectTypeTemplateRequest.Builder.() -> Unit) = getProfileObjectTypeTemplate(GetProfileObjectTypeTemplateRequest.Builder().apply(block).build())

    /**
     * Get details of specified workflow.
     */
    suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse

    /**
     * Get details of specified workflow.
     */
    suspend fun getWorkflow(block: GetWorkflowRequest.Builder.() -> Unit) = getWorkflow(GetWorkflowRequest.Builder().apply(block).build())

    /**
     * Get granular list of steps in workflow.
     */
    suspend fun getWorkflowSteps(input: GetWorkflowStepsRequest): GetWorkflowStepsResponse

    /**
     * Get granular list of steps in workflow.
     */
    suspend fun getWorkflowSteps(block: GetWorkflowStepsRequest.Builder.() -> Unit) = getWorkflowSteps(GetWorkflowStepsRequest.Builder().apply(block).build())

    /**
     * Lists all of the integrations associated to a specific URI in the AWS account.
     */
    suspend fun listAccountIntegrations(input: ListAccountIntegrationsRequest): ListAccountIntegrationsResponse

    /**
     * Lists all of the integrations associated to a specific URI in the AWS account.
     */
    suspend fun listAccountIntegrations(block: ListAccountIntegrationsRequest.Builder.() -> Unit) = listAccountIntegrations(ListAccountIntegrationsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the domains for an AWS account that have been created.
     */
    suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest {}): ListDomainsResponse

    /**
     * Returns a list of all the domains for an AWS account that have been created.
     */
    suspend fun listDomains(block: ListDomainsRequest.Builder.() -> Unit) = listDomains(ListDomainsRequest.Builder().apply(block).build())

    /**
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by `JobStartTime`.
     */
    suspend fun listIdentityResolutionJobs(input: ListIdentityResolutionJobsRequest): ListIdentityResolutionJobsResponse

    /**
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by `JobStartTime`.
     */
    suspend fun listIdentityResolutionJobs(block: ListIdentityResolutionJobsRequest.Builder.() -> Unit) = listIdentityResolutionJobs(ListIdentityResolutionJobsRequest.Builder().apply(block).build())

    /**
     * Lists all of the integrations in your domain.
     */
    suspend fun listIntegrations(input: ListIntegrationsRequest): ListIntegrationsResponse

    /**
     * Lists all of the integrations in your domain.
     */
    suspend fun listIntegrations(block: ListIntegrationsRequest.Builder.() -> Unit) = listIntegrations(ListIntegrationsRequest.Builder().apply(block).build())

    /**
     * Lists all of the template information for object types.
     */
    suspend fun listProfileObjectTypeTemplates(input: ListProfileObjectTypeTemplatesRequest = ListProfileObjectTypeTemplatesRequest {}): ListProfileObjectTypeTemplatesResponse

    /**
     * Lists all of the template information for object types.
     */
    suspend fun listProfileObjectTypeTemplates(block: ListProfileObjectTypeTemplatesRequest.Builder.() -> Unit) = listProfileObjectTypeTemplates(ListProfileObjectTypeTemplatesRequest.Builder().apply(block).build())

    /**
     * Lists all of the templates available within the service.
     */
    suspend fun listProfileObjectTypes(input: ListProfileObjectTypesRequest): ListProfileObjectTypesResponse

    /**
     * Lists all of the templates available within the service.
     */
    suspend fun listProfileObjectTypes(block: ListProfileObjectTypesRequest.Builder.() -> Unit) = listProfileObjectTypes(ListProfileObjectTypesRequest.Builder().apply(block).build())

    /**
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     */
    suspend fun listProfileObjects(input: ListProfileObjectsRequest): ListProfileObjectsResponse

    /**
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     */
    suspend fun listProfileObjects(block: ListProfileObjectsRequest.Builder.() -> Unit) = listProfileObjects(ListProfileObjectsRequest.Builder().apply(block).build())

    /**
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Query to list all workflows.
     */
    suspend fun listWorkflows(input: ListWorkflowsRequest): ListWorkflowsResponse

    /**
     * Query to list all workflows.
     */
    suspend fun listWorkflows(block: ListWorkflowsRequest.Builder.() -> Unit) = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

    /**
     * Runs an AWS Lambda job that does the following:
     * + All the profileKeys in the `ProfileToBeMerged` will be moved to the main profile.
     * + All the objects in the `ProfileToBeMerged` will be moved to the main profile.
     * + All the `ProfileToBeMerged` will be deleted at the end.
     * + All the profileKeys in the `ProfileIdsToBeMerged` will be moved to the main profile.
     * + Standard fields are merged as follows:
     *    + Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     *    + When there are conflicting fields:
     *       + If no `SourceProfileIds` entry is specified, the main Profile value is always taken.
     *       + If a `SourceProfileIds` entry is specified, the specified profileId is always taken, even if it is a NULL value.
     *
     * You can use MergeProfiles together with [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html), which returns potentially matching profiles, or use it with the results of another matching system. After profiles have been merged, they cannot be separated (unmerged).
     */
    suspend fun mergeProfiles(input: MergeProfilesRequest): MergeProfilesResponse

    /**
     * Runs an AWS Lambda job that does the following:
     * + All the profileKeys in the `ProfileToBeMerged` will be moved to the main profile.
     * + All the objects in the `ProfileToBeMerged` will be moved to the main profile.
     * + All the `ProfileToBeMerged` will be deleted at the end.
     * + All the profileKeys in the `ProfileIdsToBeMerged` will be moved to the main profile.
     * + Standard fields are merged as follows:
     *    + Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     *    + When there are conflicting fields:
     *       + If no `SourceProfileIds` entry is specified, the main Profile value is always taken.
     *       + If a `SourceProfileIds` entry is specified, the specified profileId is always taken, even if it is a NULL value.
     *
     * You can use MergeProfiles together with [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html), which returns potentially matching profiles, or use it with the results of another matching system. After profiles have been merged, they cannot be separated (unmerged).
     */
    suspend fun mergeProfiles(block: MergeProfilesRequest.Builder.() -> Unit) = mergeProfiles(MergeProfilesRequest.Builder().apply(block).build())

    /**
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.
     *
     * An integration can belong to only one domain.
     */
    suspend fun putIntegration(input: PutIntegrationRequest): PutIntegrationResponse

    /**
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.
     *
     * An integration can belong to only one domain.
     */
    suspend fun putIntegration(block: PutIntegrationRequest.Builder.() -> Unit) = putIntegration(PutIntegrationRequest.Builder().apply(block).build())

    /**
     * Adds additional objects to customer profiles of a given ObjectType.
     *
     * When adding a specific profile object, like a Contact Trace Record (CTR), an inferred profile can get created if it is not mapped to an existing profile. The resulting profile will only have a phone number populated in the standard ProfileObject. Any additional CTRs with the same phone number will be mapped to the same inferred profile.
     *
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide data to a standard profile depending on the ProfileObjectType definition.
     *
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     */
    suspend fun putProfileObject(input: PutProfileObjectRequest): PutProfileObjectResponse

    /**
     * Adds additional objects to customer profiles of a given ObjectType.
     *
     * When adding a specific profile object, like a Contact Trace Record (CTR), an inferred profile can get created if it is not mapped to an existing profile. The resulting profile will only have a phone number populated in the standard ProfileObject. Any additional CTRs with the same phone number will be mapped to the same inferred profile.
     *
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide data to a standard profile depending on the ProfileObjectType definition.
     *
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     */
    suspend fun putProfileObject(block: PutProfileObjectRequest.Builder.() -> Unit) = putProfileObject(PutProfileObjectRequest.Builder().apply(block).build())

    /**
     * Defines a ProfileObjectType.
     */
    suspend fun putProfileObjectType(input: PutProfileObjectTypeRequest): PutProfileObjectTypeResponse

    /**
     * Defines a ProfileObjectType.
     */
    suspend fun putProfileObjectType(block: PutProfileObjectTypeRequest.Builder.() -> Unit) = putProfileObjectType(PutProfileObjectTypeRequest.Builder().apply(block).build())

    /**
     * Searches for profiles within a specific domain name using name, phone number, email address, account number, or a custom defined index.
     */
    suspend fun searchProfiles(input: SearchProfilesRequest): SearchProfilesResponse

    /**
     * Searches for profiles within a specific domain name using name, phone number, email address, account number, or a custom defined index.
     */
    suspend fun searchProfiles(block: SearchProfilesRequest.Builder.() -> Unit) = searchProfiles(SearchProfilesRequest.Builder().apply(block).build())

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     *
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     *
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     *
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     *
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     *
     * After a domain is created, the name can’t be changed.
     *
     * Use this API or [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
     *
     * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
     */
    suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse

    /**
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     *
     * After a domain is created, the name can’t be changed.
     *
     * Use this API or [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
     *
     * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
     */
    suspend fun updateDomain(block: UpdateDomainRequest.Builder.() -> Unit) = updateDomain(UpdateDomainRequest.Builder().apply(block).build())

    /**
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     *
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be removed. Not specifying a string value means that any value already there will be kept.
     */
    suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse

    /**
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     *
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be removed. Not specifying a string value means that any value already there will be kept.
     */
    suspend fun updateProfile(block: UpdateProfileRequest.Builder.() -> Unit) = updateProfile(UpdateProfileRequest.Builder().apply(block).build())
}
