// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.UpdateAnomalySubscriptionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAnomalySubscriptionOperationDeserializer: HttpDeserialize<UpdateAnomalySubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateAnomalySubscriptionResponse {
        if (!response.status.isSuccess()) {
            throwUpdateAnomalySubscriptionError(context, response)
        }
        val builder = UpdateAnomalySubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateAnomalySubscriptionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateAnomalySubscriptionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnknownMonitorException" -> UnknownMonitorExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnknownSubscriptionException" -> UnknownSubscriptionExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateAnomalySubscriptionOperationBody(builder: UpdateAnomalySubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUBSCRIPTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscriptionArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBSCRIPTIONARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUBSCRIPTIONARN_DESCRIPTOR.index -> builder.subscriptionArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
