// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.DateInterval
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
import aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilizationAggregates
import aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilizationDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSavingsPlansUtilizationDetailsOperationDeserializer: HttpDeserialize<GetSavingsPlansUtilizationDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSavingsPlansUtilizationDetailsResponse {
        if (!response.status.isSuccess()) {
            throwGetSavingsPlansUtilizationDetailsError(context, response)
        }
        val builder = GetSavingsPlansUtilizationDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSavingsPlansUtilizationDetailsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSavingsPlansUtilizationDetailsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DataUnavailableException" -> DataUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSavingsPlansUtilizationDetailsOperationBody(builder: GetSavingsPlansUtilizationDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SAVINGSPLANSUTILIZATIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SavingsPlansUtilizationDetails"))
    val TIMEPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimePeriod"))
    val TOTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Total"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SAVINGSPLANSUTILIZATIONDETAILS_DESCRIPTOR)
        field(TIMEPERIOD_DESCRIPTOR)
        field(TOTAL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SAVINGSPLANSUTILIZATIONDETAILS_DESCRIPTOR.index -> builder.savingsPlansUtilizationDetails =
                    deserializer.deserializeList(SAVINGSPLANSUTILIZATIONDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<SavingsPlansUtilizationDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSavingsPlansUtilizationDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TIMEPERIOD_DESCRIPTOR.index -> builder.timePeriod = deserializeDateIntervalDocument(deserializer)
                TOTAL_DESCRIPTOR.index -> builder.total = deserializeSavingsPlansUtilizationAggregatesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
