// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
import aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendation
import aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSavingsPlansPurchaseRecommendationOperationDeserializer: HttpDeserialize<GetSavingsPlansPurchaseRecommendationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSavingsPlansPurchaseRecommendationResponse {
        if (!response.status.isSuccess()) {
            throwGetSavingsPlansPurchaseRecommendationError(context, response)
        }
        val builder = GetSavingsPlansPurchaseRecommendationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSavingsPlansPurchaseRecommendationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSavingsPlansPurchaseRecommendationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSavingsPlansPurchaseRecommendationOperationBody(builder: GetSavingsPlansPurchaseRecommendationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Metadata"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val SAVINGSPLANSPURCHASERECOMMENDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SavingsPlansPurchaseRecommendation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METADATA_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(SAVINGSPLANSPURCHASERECOMMENDATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeSavingsPlansPurchaseRecommendationMetadataDocument(deserializer)
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                SAVINGSPLANSPURCHASERECOMMENDATION_DESCRIPTOR.index -> builder.savingsPlansPurchaseRecommendation = deserializeSavingsPlansPurchaseRecommendationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
