// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.GetRightsizingRecommendationResponse
import aws.sdk.kotlin.services.costexplorer.model.RightsizingRecommendation
import aws.sdk.kotlin.services.costexplorer.model.RightsizingRecommendationConfiguration
import aws.sdk.kotlin.services.costexplorer.model.RightsizingRecommendationMetadata
import aws.sdk.kotlin.services.costexplorer.model.RightsizingRecommendationSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRightsizingRecommendationOperationDeserializer: HttpDeserialize<GetRightsizingRecommendationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRightsizingRecommendationResponse {
        if (!response.status.isSuccess()) {
            throwGetRightsizingRecommendationError(context, response)
        }
        val builder = GetRightsizingRecommendationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRightsizingRecommendationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRightsizingRecommendationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRightsizingRecommendationOperationBody(builder: GetRightsizingRecommendationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Configuration"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Metadata"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val RIGHTSIZINGRECOMMENDATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RightsizingRecommendations"))
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Summary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATION_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(RIGHTSIZINGRECOMMENDATIONS_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeRightsizingRecommendationConfigurationDocument(deserializer)
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeRightsizingRecommendationMetadataDocument(deserializer)
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                RIGHTSIZINGRECOMMENDATIONS_DESCRIPTOR.index -> builder.rightsizingRecommendations =
                    deserializer.deserializeList(RIGHTSIZINGRECOMMENDATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RightsizingRecommendation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRightsizingRecommendationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeRightsizingRecommendationSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
