// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationResponse
import aws.sdk.kotlin.services.costexplorer.model.ReservationAggregates
import aws.sdk.kotlin.services.costexplorer.model.UtilizationByTime
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetReservationUtilizationOperationDeserializer: HttpDeserialize<GetReservationUtilizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetReservationUtilizationResponse {
        if (!response.status.isSuccess()) {
            throwGetReservationUtilizationError(context, response)
        }
        val builder = GetReservationUtilizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetReservationUtilizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetReservationUtilizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DataUnavailableException" -> DataUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReservationUtilizationOperationBody(builder: GetReservationUtilizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val TOTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Total"))
    val UTILIZATIONSBYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UtilizationsByTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(TOTAL_DESCRIPTOR)
        field(UTILIZATIONSBYTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                TOTAL_DESCRIPTOR.index -> builder.total = deserializeReservationAggregatesDocument(deserializer)
                UTILIZATIONSBYTIME_DESCRIPTOR.index -> builder.utilizationsByTime =
                    deserializer.deserializeList(UTILIZATIONSBYTIME_DESCRIPTOR) {
                        val col0 = mutableListOf<UtilizationByTime>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUtilizationByTimeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
