// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.Coverage
import aws.sdk.kotlin.services.costexplorer.model.CoverageByTime
import aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetReservationCoverageOperationDeserializer: HttpDeserialize<GetReservationCoverageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetReservationCoverageResponse {
        if (!response.status.isSuccess()) {
            throwGetReservationCoverageError(context, response)
        }
        val builder = GetReservationCoverageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetReservationCoverageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetReservationCoverageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DataUnavailableException" -> DataUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetReservationCoverageOperationBody(builder: GetReservationCoverageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COVERAGESBYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CoveragesByTime"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val TOTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Total"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COVERAGESBYTIME_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(TOTAL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COVERAGESBYTIME_DESCRIPTOR.index -> builder.coveragesByTime =
                    deserializer.deserializeList(COVERAGESBYTIME_DESCRIPTOR) {
                        val col0 = mutableListOf<CoverageByTime>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCoverageByTimeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                TOTAL_DESCRIPTOR.index -> builder.total = deserializeCoverageDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
