// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.DimensionValuesWithAttributes
import aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDimensionValuesOperationDeserializer: HttpDeserialize<GetDimensionValuesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDimensionValuesResponse {
        if (!response.status.isSuccess()) {
            throwGetDimensionValuesError(context, response)
        }
        val builder = GetDimensionValuesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDimensionValuesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDimensionValuesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BillExpirationException" -> BillExpirationExceptionDeserializer().deserialize(context, wrappedResponse)
        "DataUnavailableException" -> DataUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestChangedException" -> RequestChangedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDimensionValuesOperationBody(builder: GetDimensionValuesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DIMENSIONVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DimensionValues"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val RETURNSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ReturnSize"))
    val TOTALSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalSize"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DIMENSIONVALUES_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(RETURNSIZE_DESCRIPTOR)
        field(TOTALSIZE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DIMENSIONVALUES_DESCRIPTOR.index -> builder.dimensionValues =
                    deserializer.deserializeList(DIMENSIONVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<DimensionValuesWithAttributes>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDimensionValuesWithAttributesDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                RETURNSIZE_DESCRIPTOR.index -> builder.returnSize = deserializeInt()
                TOTALSIZE_DESCRIPTOR.index -> builder.totalSize = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
