// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.ForecastResult
import aws.sdk.kotlin.services.costexplorer.model.GetCostForecastResponse
import aws.sdk.kotlin.services.costexplorer.model.MetricValue
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCostForecastOperationDeserializer: HttpDeserialize<GetCostForecastResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCostForecastResponse {
        if (!response.status.isSuccess()) {
            throwGetCostForecastError(context, response)
        }
        val builder = GetCostForecastResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCostForecastOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCostForecastError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DataUnavailableException" -> DataUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCostForecastOperationBody(builder: GetCostForecastResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FORECASTRESULTSBYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastResultsByTime"))
    val TOTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Total"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FORECASTRESULTSBYTIME_DESCRIPTOR)
        field(TOTAL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FORECASTRESULTSBYTIME_DESCRIPTOR.index -> builder.forecastResultsByTime =
                    deserializer.deserializeList(FORECASTRESULTSBYTIME_DESCRIPTOR) {
                        val col0 = mutableListOf<ForecastResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeForecastResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTAL_DESCRIPTOR.index -> builder.total = deserializeMetricValueDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
