// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.DimensionValuesWithAttributes
import aws.sdk.kotlin.services.costexplorer.model.GetCostAndUsageResponse
import aws.sdk.kotlin.services.costexplorer.model.GroupDefinition
import aws.sdk.kotlin.services.costexplorer.model.ResultByTime
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCostAndUsageOperationDeserializer: HttpDeserialize<GetCostAndUsageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCostAndUsageResponse {
        if (!response.status.isSuccess()) {
            throwGetCostAndUsageError(context, response)
        }
        val builder = GetCostAndUsageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCostAndUsageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCostAndUsageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BillExpirationException" -> BillExpirationExceptionDeserializer().deserialize(context, wrappedResponse)
        "DataUnavailableException" -> DataUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestChangedException" -> RequestChangedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCostAndUsageOperationBody(builder: GetCostAndUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DIMENSIONVALUEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DimensionValueAttributes"))
    val GROUPDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GroupDefinitions"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val RESULTSBYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultsByTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DIMENSIONVALUEATTRIBUTES_DESCRIPTOR)
        field(GROUPDEFINITIONS_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(RESULTSBYTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DIMENSIONVALUEATTRIBUTES_DESCRIPTOR.index -> builder.dimensionValueAttributes =
                    deserializer.deserializeList(DIMENSIONVALUEATTRIBUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<DimensionValuesWithAttributes>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDimensionValuesWithAttributesDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GROUPDEFINITIONS_DESCRIPTOR.index -> builder.groupDefinitions =
                    deserializer.deserializeList(GROUPDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                RESULTSBYTIME_DESCRIPTOR.index -> builder.resultsByTime =
                    deserializer.deserializeList(RESULTSBYTIME_DESCRIPTOR) {
                        val col0 = mutableListOf<ResultByTime>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResultByTimeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
