// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costexplorer.model.AnomalySubscription
import aws.sdk.kotlin.services.costexplorer.model.CostExplorerException
import aws.sdk.kotlin.services.costexplorer.model.GetAnomalySubscriptionsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAnomalySubscriptionsOperationDeserializer: HttpDeserialize<GetAnomalySubscriptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAnomalySubscriptionsResponse {
        if (!response.status.isSuccess()) {
            throwGetAnomalySubscriptionsError(context, response)
        }
        val builder = GetAnomalySubscriptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAnomalySubscriptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAnomalySubscriptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostExplorerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnknownSubscriptionException" -> UnknownSubscriptionExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostExplorerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAnomalySubscriptionsOperationBody(builder: GetAnomalySubscriptionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYSUBSCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AnomalySubscriptions"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYSUBSCRIPTIONS_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYSUBSCRIPTIONS_DESCRIPTOR.index -> builder.anomalySubscriptions =
                    deserializer.deserializeList(ANOMALYSUBSCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AnomalySubscription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnomalySubscriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
