// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.paginators

import aws.sdk.kotlin.services.costexplorer.CostExplorerClient
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageRequest
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageResponse
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
import aws.sdk.kotlin.services.costexplorer.model.ListCostAllocationTagsRequest
import aws.sdk.kotlin.services.costexplorer.model.ListCostAllocationTagsResponse
import aws.sdk.kotlin.services.costexplorer.model.ListCostCategoryDefinitionsRequest
import aws.sdk.kotlin.services.costexplorer.model.ListCostCategoryDefinitionsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetSavingsPlansCoverageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSavingsPlansCoverageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSavingsPlansCoverageResponse]
 */
public fun CostExplorerClient.getSavingsPlansCoveragePaginated(initialRequest: GetSavingsPlansCoverageRequest): Flow<GetSavingsPlansCoverageResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSavingsPlansCoveragePaginated.getSavingsPlansCoverage(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetSavingsPlansCoverageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSavingsPlansCoverageResponse]
 */
public fun CostExplorerClient.getSavingsPlansCoveragePaginated(block: GetSavingsPlansCoverageRequest.Builder.() -> Unit): Flow<GetSavingsPlansCoverageResponse> =
    getSavingsPlansCoveragePaginated(GetSavingsPlansCoverageRequest.Builder().apply(block).build())

/**
 * Paginate over [GetSavingsPlansUtilizationDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSavingsPlansUtilizationDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSavingsPlansUtilizationDetailsResponse]
 */
public fun CostExplorerClient.getSavingsPlansUtilizationDetailsPaginated(initialRequest: GetSavingsPlansUtilizationDetailsRequest): Flow<GetSavingsPlansUtilizationDetailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSavingsPlansUtilizationDetailsPaginated.getSavingsPlansUtilizationDetails(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetSavingsPlansUtilizationDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSavingsPlansUtilizationDetailsResponse]
 */
public fun CostExplorerClient.getSavingsPlansUtilizationDetailsPaginated(block: GetSavingsPlansUtilizationDetailsRequest.Builder.() -> Unit): Flow<GetSavingsPlansUtilizationDetailsResponse> =
    getSavingsPlansUtilizationDetailsPaginated(GetSavingsPlansUtilizationDetailsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCostAllocationTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCostAllocationTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCostAllocationTagsResponse]
 */
public fun CostExplorerClient.listCostAllocationTagsPaginated(initialRequest: ListCostAllocationTagsRequest): Flow<ListCostAllocationTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCostAllocationTagsPaginated.listCostAllocationTags(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCostAllocationTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCostAllocationTagsResponse]
 */
public fun CostExplorerClient.listCostAllocationTagsPaginated(block: ListCostAllocationTagsRequest.Builder.() -> Unit): Flow<ListCostAllocationTagsResponse> =
    listCostAllocationTagsPaginated(ListCostAllocationTagsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCostCategoryDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCostCategoryDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCostCategoryDefinitionsResponse]
 */
public fun CostExplorerClient.listCostCategoryDefinitionsPaginated(initialRequest: ListCostCategoryDefinitionsRequest): Flow<ListCostCategoryDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCostCategoryDefinitionsPaginated.listCostCategoryDefinitions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCostCategoryDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCostCategoryDefinitionsResponse]
 */
public fun CostExplorerClient.listCostCategoryDefinitionsPaginated(block: ListCostCategoryDefinitionsRequest.Builder.() -> Unit): Flow<ListCostCategoryDefinitionsResponse> =
    listCostCategoryDefinitionsPaginated(ListCostCategoryDefinitionsRequest.Builder().apply(block).build())
