// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Details on recommended instance.
 */
public class TargetInstance private constructor(builder: Builder) {
    /**
     * The currency code that Amazon Web Services used to calculate the costs for this instance.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * Determines whether this recommendation is the defaulted Amazon Web Services recommendation.
     */
    public val defaultTargetInstance: kotlin.Boolean = builder.defaultTargetInstance
    /**
     * The expected cost to operate this instance type on a monthly basis.
     */
    public val estimatedMonthlyCost: kotlin.String? = builder.estimatedMonthlyCost
    /**
     * The estimated savings that result from modification, on a monthly basis.
     */
    public val estimatedMonthlySavings: kotlin.String? = builder.estimatedMonthlySavings
    /**
     * The expected utilization metrics for target instance type.
     */
    public val expectedResourceUtilization: aws.sdk.kotlin.services.costexplorer.model.ResourceUtilization? = builder.expectedResourceUtilization
    /**
     * Explains the actions that you might need to take to successfully migrate your workloads from the current instance type to the recommended instance type.
     */
    public val platformDifferences: List<PlatformDifference>? = builder.platformDifferences
    /**
     * Details on the target instance type.
     */
    public val resourceDetails: aws.sdk.kotlin.services.costexplorer.model.ResourceDetails? = builder.resourceDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.TargetInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetInstance(")
        append("currencyCode=$currencyCode,")
        append("defaultTargetInstance=$defaultTargetInstance,")
        append("estimatedMonthlyCost=$estimatedMonthlyCost,")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("expectedResourceUtilization=$expectedResourceUtilization,")
        append("platformDifferences=$platformDifferences,")
        append("resourceDetails=$resourceDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (defaultTargetInstance.hashCode())
        result = 31 * result + (estimatedMonthlyCost?.hashCode() ?: 0)
        result = 31 * result + (estimatedMonthlySavings?.hashCode() ?: 0)
        result = 31 * result + (expectedResourceUtilization?.hashCode() ?: 0)
        result = 31 * result + (platformDifferences?.hashCode() ?: 0)
        result = 31 * result + (resourceDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetInstance

        if (currencyCode != other.currencyCode) return false
        if (defaultTargetInstance != other.defaultTargetInstance) return false
        if (estimatedMonthlyCost != other.estimatedMonthlyCost) return false
        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (expectedResourceUtilization != other.expectedResourceUtilization) return false
        if (platformDifferences != other.platformDifferences) return false
        if (resourceDetails != other.resourceDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.TargetInstance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The currency code that Amazon Web Services used to calculate the costs for this instance.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * Determines whether this recommendation is the defaulted Amazon Web Services recommendation.
         */
        public var defaultTargetInstance: kotlin.Boolean = false
        /**
         * The expected cost to operate this instance type on a monthly basis.
         */
        public var estimatedMonthlyCost: kotlin.String? = null
        /**
         * The estimated savings that result from modification, on a monthly basis.
         */
        public var estimatedMonthlySavings: kotlin.String? = null
        /**
         * The expected utilization metrics for target instance type.
         */
        public var expectedResourceUtilization: aws.sdk.kotlin.services.costexplorer.model.ResourceUtilization? = null
        /**
         * Explains the actions that you might need to take to successfully migrate your workloads from the current instance type to the recommended instance type.
         */
        public var platformDifferences: List<PlatformDifference>? = null
        /**
         * Details on the target instance type.
         */
        public var resourceDetails: aws.sdk.kotlin.services.costexplorer.model.ResourceDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.TargetInstance) : this() {
            this.currencyCode = x.currencyCode
            this.defaultTargetInstance = x.defaultTargetInstance
            this.estimatedMonthlyCost = x.estimatedMonthlyCost
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.expectedResourceUtilization = x.expectedResourceUtilization
            this.platformDifferences = x.platformDifferences
            this.resourceDetails = x.resourceDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.TargetInstance = TargetInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.ResourceUtilization] inside the given [block]
         */
        public fun expectedResourceUtilization(block: aws.sdk.kotlin.services.costexplorer.model.ResourceUtilization.Builder.() -> kotlin.Unit) {
            this.expectedResourceUtilization = aws.sdk.kotlin.services.costexplorer.model.ResourceUtilization.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.ResourceDetails] inside the given [block]
         */
        public fun resourceDetails(block: aws.sdk.kotlin.services.costexplorer.model.ResourceDetails.Builder.() -> kotlin.Unit) {
            this.resourceDetails = aws.sdk.kotlin.services.costexplorer.model.ResourceDetails.invoke(block)
        }
    }
}
