// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * The values that are available for a tag.
 *
 * If `Values` and `Key` aren't specified, the `ABSENT``MatchOption` is applied to all tags. That is, it's filtered on resources with no tags.
 *
 * If `Key` is provided and `Values` isn't specified, the `ABSENT``MatchOption` is applied to the tag `Key` only. That is, it's filtered on resources without the given tag key.
 */
public class TagValues private constructor(builder: Builder) {
    /**
     * The key for the tag.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The match options that you can use to filter your results. `MatchOptions` is only applicable for actions related to Cost Category. The default values for `MatchOptions` are `EQUALS` and `CASE_SENSITIVE`.
     */
    public val matchOptions: List<MatchOption>? = builder.matchOptions
    /**
     * The specific value of the tag.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.TagValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagValues(")
        append("key=$key,")
        append("matchOptions=$matchOptions,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (matchOptions?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagValues

        if (key != other.key) return false
        if (matchOptions != other.matchOptions) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.TagValues = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The key for the tag.
         */
        public var key: kotlin.String? = null
        /**
         * The match options that you can use to filter your results. `MatchOptions` is only applicable for actions related to Cost Category. The default values for `MatchOptions` are `EQUALS` and `CASE_SENSITIVE`.
         */
        public var matchOptions: List<MatchOption>? = null
        /**
         * The specific value of the tag.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.TagValues) : this() {
            this.key = x.key
            this.matchOptions = x.matchOptions
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.TagValues = TagValues(this)
    }
}
