// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource. For a list of supported resources, see [ResourceTag](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A list of tag key-value pairs to be added to the resource.
     *
     * Each tag consists of a key and a value, and each key must be unique for the resource. The following restrictions apply to resource tags:
     * + Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one resource. The remaining are reserved for Amazon Web Services use
     * + The maximum length of a key is 128 characters
     * + The maximum length of a value is 256 characters
     * + Keys and values can only contain alphanumeric characters, spaces, and any of the following: `_.:/=+@-`
     * + Keys and values are case sensitive
     * + Keys and values are trimmed for any leading or trailing whitespaces
     * + Don’t use `aws:` as a prefix for your keys. This prefix is reserved for Amazon Web Services use
     */
    public val resourceTags: List<ResourceTag>? = builder.resourceTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("resourceTags=$resourceTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (resourceTags != other.resourceTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.TagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource. For a list of supported resources, see [ResourceTag](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
         */
        public var resourceArn: kotlin.String? = null
        /**
         * A list of tag key-value pairs to be added to the resource.
         *
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following restrictions apply to resource tags:
         * + Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one resource. The remaining are reserved for Amazon Web Services use
         * + The maximum length of a key is 128 characters
         * + The maximum length of a value is 256 characters
         * + Keys and values can only contain alphanumeric characters, spaces, and any of the following: `_.:/=+@-`
         * + Keys and values are case sensitive
         * + Keys and values are trimmed for any leading or trailing whitespaces
         * + Don’t use `aws:` as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         */
        public var resourceTags: List<ResourceTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.resourceTags = x.resourceTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.TagResourceRequest = TagResourceRequest(this)
    }
}
