// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * A single daily or monthly Savings Plans utilization rate and details for your account. A management account in an organization have access to member accounts. You can use `GetDimensionValues` to determine the possible dimension values.
 */
public class SavingsPlansUtilizationDetail private constructor(builder: Builder) {
    /**
     * The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans fees.
     */
    public val amortizedCommitment: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansAmortizedCommitment? = builder.amortizedCommitment
    /**
     * The attribute that applies to a specific `Dimension`.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans and also the `onDemandCostEquivalent` of the Savings Plans when considering the utilization rate.
     */
    public val savings: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansSavings? = builder.savings
    /**
     * The unique Amazon Resource Name (ARN) for a particular Savings Plan.
     */
    public val savingsPlanArn: kotlin.String? = builder.savingsPlanArn
    /**
     * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.
     */
    public val utilization: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilization? = builder.utilization

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilizationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SavingsPlansUtilizationDetail(")
        append("amortizedCommitment=$amortizedCommitment,")
        append("attributes=$attributes,")
        append("savings=$savings,")
        append("savingsPlanArn=$savingsPlanArn,")
        append("utilization=$utilization)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amortizedCommitment?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (savings?.hashCode() ?: 0)
        result = 31 * result + (savingsPlanArn?.hashCode() ?: 0)
        result = 31 * result + (utilization?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SavingsPlansUtilizationDetail

        if (amortizedCommitment != other.amortizedCommitment) return false
        if (attributes != other.attributes) return false
        if (savings != other.savings) return false
        if (savingsPlanArn != other.savingsPlanArn) return false
        if (utilization != other.utilization) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilizationDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans fees.
         */
        public var amortizedCommitment: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansAmortizedCommitment? = null
        /**
         * The attribute that applies to a specific `Dimension`.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans and also the `onDemandCostEquivalent` of the Savings Plans when considering the utilization rate.
         */
        public var savings: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansSavings? = null
        /**
         * The unique Amazon Resource Name (ARN) for a particular Savings Plan.
         */
        public var savingsPlanArn: kotlin.String? = null
        /**
         * A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.
         */
        public var utilization: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilization? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilizationDetail) : this() {
            this.amortizedCommitment = x.amortizedCommitment
            this.attributes = x.attributes
            this.savings = x.savings
            this.savingsPlanArn = x.savingsPlanArn
            this.utilization = x.utilization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilizationDetail = SavingsPlansUtilizationDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SavingsPlansAmortizedCommitment] inside the given [block]
         */
        public fun amortizedCommitment(block: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansAmortizedCommitment.Builder.() -> kotlin.Unit) {
            this.amortizedCommitment = aws.sdk.kotlin.services.costexplorer.model.SavingsPlansAmortizedCommitment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SavingsPlansSavings] inside the given [block]
         */
        public fun savings(block: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansSavings.Builder.() -> kotlin.Unit) {
            this.savings = aws.sdk.kotlin.services.costexplorer.model.SavingsPlansSavings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilization] inside the given [block]
         */
        public fun utilization(block: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilization.Builder.() -> kotlin.Unit) {
            this.utilization = aws.sdk.kotlin.services.costexplorer.model.SavingsPlansUtilization.invoke(block)
        }
    }
}
