// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Summary metrics for your Savings Plans Purchase Recommendations.
 */
public class SavingsPlansPurchaseRecommendationSummary private constructor(builder: Builder) {
    /**
     * The currency code that Amazon Web Services used to generate the recommendations and present potential savings.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The current total on demand spend of the applicable usage types over the lookback period.
     */
    public val currentOnDemandSpend: kotlin.String? = builder.currentOnDemandSpend
    /**
     * The recommended Savings Plans cost on a daily (24 hourly) basis.
     */
    public val dailyCommitmentToPurchase: kotlin.String? = builder.dailyCommitmentToPurchase
    /**
     * The estimated monthly savings amount that's based on the recommended Savings Plans purchase.
     */
    public val estimatedMonthlySavingsAmount: kotlin.String? = builder.estimatedMonthlySavingsAmount
    /**
     * The estimated On-Demand costs you expect with no additional commitment. It's based on your usage of the selected time period and the Savings Plans you own.
     */
    public val estimatedOnDemandCostWithCurrentCommitment: kotlin.String? = builder.estimatedOnDemandCostWithCurrentCommitment
    /**
     * The estimated return on investment that's based on the recommended Savings Plans and estimated savings.
     */
    public val estimatedRoi: kotlin.String? = builder.estimatedRoi
    /**
     * The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.
     */
    public val estimatedSavingsAmount: kotlin.String? = builder.estimatedSavingsAmount
    /**
     * The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated as `estimatedSavingsAmount`/ `CurrentOnDemandSpend`*100.
     */
    public val estimatedSavingsPercentage: kotlin.String? = builder.estimatedSavingsPercentage
    /**
     * The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost of Savings Plans during this term, and the remaining On-Demand usage.
     */
    public val estimatedTotalCost: kotlin.String? = builder.estimatedTotalCost
    /**
     * The recommended hourly commitment that's based on the recommendation parameters.
     */
    public val hourlyCommitmentToPurchase: kotlin.String? = builder.hourlyCommitmentToPurchase
    /**
     * The aggregate number of Savings Plans recommendations that exist for your account.
     */
    public val totalRecommendationCount: kotlin.String? = builder.totalRecommendationCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SavingsPlansPurchaseRecommendationSummary(")
        append("currencyCode=$currencyCode,")
        append("currentOnDemandSpend=$currentOnDemandSpend,")
        append("dailyCommitmentToPurchase=$dailyCommitmentToPurchase,")
        append("estimatedMonthlySavingsAmount=$estimatedMonthlySavingsAmount,")
        append("estimatedOnDemandCostWithCurrentCommitment=$estimatedOnDemandCostWithCurrentCommitment,")
        append("estimatedRoi=$estimatedRoi,")
        append("estimatedSavingsAmount=$estimatedSavingsAmount,")
        append("estimatedSavingsPercentage=$estimatedSavingsPercentage,")
        append("estimatedTotalCost=$estimatedTotalCost,")
        append("hourlyCommitmentToPurchase=$hourlyCommitmentToPurchase,")
        append("totalRecommendationCount=$totalRecommendationCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (currentOnDemandSpend?.hashCode() ?: 0)
        result = 31 * result + (dailyCommitmentToPurchase?.hashCode() ?: 0)
        result = 31 * result + (estimatedMonthlySavingsAmount?.hashCode() ?: 0)
        result = 31 * result + (estimatedOnDemandCostWithCurrentCommitment?.hashCode() ?: 0)
        result = 31 * result + (estimatedRoi?.hashCode() ?: 0)
        result = 31 * result + (estimatedSavingsAmount?.hashCode() ?: 0)
        result = 31 * result + (estimatedSavingsPercentage?.hashCode() ?: 0)
        result = 31 * result + (estimatedTotalCost?.hashCode() ?: 0)
        result = 31 * result + (hourlyCommitmentToPurchase?.hashCode() ?: 0)
        result = 31 * result + (totalRecommendationCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SavingsPlansPurchaseRecommendationSummary

        if (currencyCode != other.currencyCode) return false
        if (currentOnDemandSpend != other.currentOnDemandSpend) return false
        if (dailyCommitmentToPurchase != other.dailyCommitmentToPurchase) return false
        if (estimatedMonthlySavingsAmount != other.estimatedMonthlySavingsAmount) return false
        if (estimatedOnDemandCostWithCurrentCommitment != other.estimatedOnDemandCostWithCurrentCommitment) return false
        if (estimatedRoi != other.estimatedRoi) return false
        if (estimatedSavingsAmount != other.estimatedSavingsAmount) return false
        if (estimatedSavingsPercentage != other.estimatedSavingsPercentage) return false
        if (estimatedTotalCost != other.estimatedTotalCost) return false
        if (hourlyCommitmentToPurchase != other.hourlyCommitmentToPurchase) return false
        if (totalRecommendationCount != other.totalRecommendationCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The currency code that Amazon Web Services used to generate the recommendations and present potential savings.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The current total on demand spend of the applicable usage types over the lookback period.
         */
        public var currentOnDemandSpend: kotlin.String? = null
        /**
         * The recommended Savings Plans cost on a daily (24 hourly) basis.
         */
        public var dailyCommitmentToPurchase: kotlin.String? = null
        /**
         * The estimated monthly savings amount that's based on the recommended Savings Plans purchase.
         */
        public var estimatedMonthlySavingsAmount: kotlin.String? = null
        /**
         * The estimated On-Demand costs you expect with no additional commitment. It's based on your usage of the selected time period and the Savings Plans you own.
         */
        public var estimatedOnDemandCostWithCurrentCommitment: kotlin.String? = null
        /**
         * The estimated return on investment that's based on the recommended Savings Plans and estimated savings.
         */
        public var estimatedRoi: kotlin.String? = null
        /**
         * The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.
         */
        public var estimatedSavingsAmount: kotlin.String? = null
        /**
         * The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated as `estimatedSavingsAmount`/ `CurrentOnDemandSpend`*100.
         */
        public var estimatedSavingsPercentage: kotlin.String? = null
        /**
         * The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost of Savings Plans during this term, and the remaining On-Demand usage.
         */
        public var estimatedTotalCost: kotlin.String? = null
        /**
         * The recommended hourly commitment that's based on the recommendation parameters.
         */
        public var hourlyCommitmentToPurchase: kotlin.String? = null
        /**
         * The aggregate number of Savings Plans recommendations that exist for your account.
         */
        public var totalRecommendationCount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary) : this() {
            this.currencyCode = x.currencyCode
            this.currentOnDemandSpend = x.currentOnDemandSpend
            this.dailyCommitmentToPurchase = x.dailyCommitmentToPurchase
            this.estimatedMonthlySavingsAmount = x.estimatedMonthlySavingsAmount
            this.estimatedOnDemandCostWithCurrentCommitment = x.estimatedOnDemandCostWithCurrentCommitment
            this.estimatedRoi = x.estimatedRoi
            this.estimatedSavingsAmount = x.estimatedSavingsAmount
            this.estimatedSavingsPercentage = x.estimatedSavingsPercentage
            this.estimatedTotalCost = x.estimatedTotalCost
            this.hourlyCommitmentToPurchase = x.hourlyCommitmentToPurchase
            this.totalRecommendationCount = x.totalRecommendationCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary = SavingsPlansPurchaseRecommendationSummary(this)
    }
}
