// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Details for your recommended Savings Plans.
 */
public class SavingsPlansPurchaseRecommendationDetail private constructor(builder: Builder) {
    /**
     * The `AccountID` the recommendation is generated for.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The currency code that Amazon Web Services used to generate the recommendations and present potential savings.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public val currentAverageHourlyOnDemandSpend: kotlin.String? = builder.currentAverageHourlyOnDemandSpend
    /**
     * The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public val currentMaximumHourlyOnDemandSpend: kotlin.String? = builder.currentMaximumHourlyOnDemandSpend
    /**
     * The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public val currentMinimumHourlyOnDemandSpend: kotlin.String? = builder.currentMinimumHourlyOnDemandSpend
    /**
     * The estimated utilization of the recommended Savings Plans.
     */
    public val estimatedAverageUtilization: kotlin.String? = builder.estimatedAverageUtilization
    /**
     * The estimated monthly savings amount based on the recommended Savings Plans.
     */
    public val estimatedMonthlySavingsAmount: kotlin.String? = builder.estimatedMonthlySavingsAmount
    /**
     * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the lookback period.
     */
    public val estimatedOnDemandCost: kotlin.String? = builder.estimatedOnDemandCost
    /**
     * The estimated On-Demand costs you expect with no additional commitment, based on your usage of the selected time period and the Savings Plans you own.
     */
    public val estimatedOnDemandCostWithCurrentCommitment: kotlin.String? = builder.estimatedOnDemandCostWithCurrentCommitment
    /**
     * The estimated return on investment that's based on the recommended Savings Plans that you purchased. This is calculated as `estimatedSavingsAmount`/ `estimatedSPCost`*100.
     */
    public val estimatedRoi: kotlin.String? = builder.estimatedRoi
    /**
     * The estimated savings amount that's based on the recommended Savings Plans over the length of the lookback period.
     */
    public val estimatedSavingsAmount: kotlin.String? = builder.estimatedSavingsAmount
    /**
     * The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback period.
     */
    public val estimatedSavingsPercentage: kotlin.String? = builder.estimatedSavingsPercentage
    /**
     * The cost of the recommended Savings Plans over the length of the lookback period.
     */
    public val estimatedSpCost: kotlin.String? = builder.estimatedSpCost
    /**
     * The recommended hourly commitment level for the Savings Plans type and the configuration that's based on the usage during the lookback period.
     */
    public val hourlyCommitmentToPurchase: kotlin.String? = builder.hourlyCommitmentToPurchase
    /**
     * Details for your recommended Savings Plans.
     */
    public val savingsPlansDetails: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansDetails? = builder.savingsPlansDetails
    /**
     * The upfront cost of the recommended Savings Plans, based on the selected payment option.
     */
    public val upfrontCost: kotlin.String? = builder.upfrontCost

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SavingsPlansPurchaseRecommendationDetail(")
        append("accountId=$accountId,")
        append("currencyCode=$currencyCode,")
        append("currentAverageHourlyOnDemandSpend=$currentAverageHourlyOnDemandSpend,")
        append("currentMaximumHourlyOnDemandSpend=$currentMaximumHourlyOnDemandSpend,")
        append("currentMinimumHourlyOnDemandSpend=$currentMinimumHourlyOnDemandSpend,")
        append("estimatedAverageUtilization=$estimatedAverageUtilization,")
        append("estimatedMonthlySavingsAmount=$estimatedMonthlySavingsAmount,")
        append("estimatedOnDemandCost=$estimatedOnDemandCost,")
        append("estimatedOnDemandCostWithCurrentCommitment=$estimatedOnDemandCostWithCurrentCommitment,")
        append("estimatedRoi=$estimatedRoi,")
        append("estimatedSavingsAmount=$estimatedSavingsAmount,")
        append("estimatedSavingsPercentage=$estimatedSavingsPercentage,")
        append("estimatedSpCost=$estimatedSpCost,")
        append("hourlyCommitmentToPurchase=$hourlyCommitmentToPurchase,")
        append("savingsPlansDetails=$savingsPlansDetails,")
        append("upfrontCost=$upfrontCost)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (currentAverageHourlyOnDemandSpend?.hashCode() ?: 0)
        result = 31 * result + (currentMaximumHourlyOnDemandSpend?.hashCode() ?: 0)
        result = 31 * result + (currentMinimumHourlyOnDemandSpend?.hashCode() ?: 0)
        result = 31 * result + (estimatedAverageUtilization?.hashCode() ?: 0)
        result = 31 * result + (estimatedMonthlySavingsAmount?.hashCode() ?: 0)
        result = 31 * result + (estimatedOnDemandCost?.hashCode() ?: 0)
        result = 31 * result + (estimatedOnDemandCostWithCurrentCommitment?.hashCode() ?: 0)
        result = 31 * result + (estimatedRoi?.hashCode() ?: 0)
        result = 31 * result + (estimatedSavingsAmount?.hashCode() ?: 0)
        result = 31 * result + (estimatedSavingsPercentage?.hashCode() ?: 0)
        result = 31 * result + (estimatedSpCost?.hashCode() ?: 0)
        result = 31 * result + (hourlyCommitmentToPurchase?.hashCode() ?: 0)
        result = 31 * result + (savingsPlansDetails?.hashCode() ?: 0)
        result = 31 * result + (upfrontCost?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SavingsPlansPurchaseRecommendationDetail

        if (accountId != other.accountId) return false
        if (currencyCode != other.currencyCode) return false
        if (currentAverageHourlyOnDemandSpend != other.currentAverageHourlyOnDemandSpend) return false
        if (currentMaximumHourlyOnDemandSpend != other.currentMaximumHourlyOnDemandSpend) return false
        if (currentMinimumHourlyOnDemandSpend != other.currentMinimumHourlyOnDemandSpend) return false
        if (estimatedAverageUtilization != other.estimatedAverageUtilization) return false
        if (estimatedMonthlySavingsAmount != other.estimatedMonthlySavingsAmount) return false
        if (estimatedOnDemandCost != other.estimatedOnDemandCost) return false
        if (estimatedOnDemandCostWithCurrentCommitment != other.estimatedOnDemandCostWithCurrentCommitment) return false
        if (estimatedRoi != other.estimatedRoi) return false
        if (estimatedSavingsAmount != other.estimatedSavingsAmount) return false
        if (estimatedSavingsPercentage != other.estimatedSavingsPercentage) return false
        if (estimatedSpCost != other.estimatedSpCost) return false
        if (hourlyCommitmentToPurchase != other.hourlyCommitmentToPurchase) return false
        if (savingsPlansDetails != other.savingsPlansDetails) return false
        if (upfrontCost != other.upfrontCost) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `AccountID` the recommendation is generated for.
         */
        public var accountId: kotlin.String? = null
        /**
         * The currency code that Amazon Web Services used to generate the recommendations and present potential savings.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
         */
        public var currentAverageHourlyOnDemandSpend: kotlin.String? = null
        /**
         * The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         */
        public var currentMaximumHourlyOnDemandSpend: kotlin.String? = null
        /**
         * The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         */
        public var currentMinimumHourlyOnDemandSpend: kotlin.String? = null
        /**
         * The estimated utilization of the recommended Savings Plans.
         */
        public var estimatedAverageUtilization: kotlin.String? = null
        /**
         * The estimated monthly savings amount based on the recommended Savings Plans.
         */
        public var estimatedMonthlySavingsAmount: kotlin.String? = null
        /**
         * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the lookback period.
         */
        public var estimatedOnDemandCost: kotlin.String? = null
        /**
         * The estimated On-Demand costs you expect with no additional commitment, based on your usage of the selected time period and the Savings Plans you own.
         */
        public var estimatedOnDemandCostWithCurrentCommitment: kotlin.String? = null
        /**
         * The estimated return on investment that's based on the recommended Savings Plans that you purchased. This is calculated as `estimatedSavingsAmount`/ `estimatedSPCost`*100.
         */
        public var estimatedRoi: kotlin.String? = null
        /**
         * The estimated savings amount that's based on the recommended Savings Plans over the length of the lookback period.
         */
        public var estimatedSavingsAmount: kotlin.String? = null
        /**
         * The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback period.
         */
        public var estimatedSavingsPercentage: kotlin.String? = null
        /**
         * The cost of the recommended Savings Plans over the length of the lookback period.
         */
        public var estimatedSpCost: kotlin.String? = null
        /**
         * The recommended hourly commitment level for the Savings Plans type and the configuration that's based on the usage during the lookback period.
         */
        public var hourlyCommitmentToPurchase: kotlin.String? = null
        /**
         * Details for your recommended Savings Plans.
         */
        public var savingsPlansDetails: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansDetails? = null
        /**
         * The upfront cost of the recommended Savings Plans, based on the selected payment option.
         */
        public var upfrontCost: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail) : this() {
            this.accountId = x.accountId
            this.currencyCode = x.currencyCode
            this.currentAverageHourlyOnDemandSpend = x.currentAverageHourlyOnDemandSpend
            this.currentMaximumHourlyOnDemandSpend = x.currentMaximumHourlyOnDemandSpend
            this.currentMinimumHourlyOnDemandSpend = x.currentMinimumHourlyOnDemandSpend
            this.estimatedAverageUtilization = x.estimatedAverageUtilization
            this.estimatedMonthlySavingsAmount = x.estimatedMonthlySavingsAmount
            this.estimatedOnDemandCost = x.estimatedOnDemandCost
            this.estimatedOnDemandCostWithCurrentCommitment = x.estimatedOnDemandCostWithCurrentCommitment
            this.estimatedRoi = x.estimatedRoi
            this.estimatedSavingsAmount = x.estimatedSavingsAmount
            this.estimatedSavingsPercentage = x.estimatedSavingsPercentage
            this.estimatedSpCost = x.estimatedSpCost
            this.hourlyCommitmentToPurchase = x.hourlyCommitmentToPurchase
            this.savingsPlansDetails = x.savingsPlansDetails
            this.upfrontCost = x.upfrontCost
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationDetail = SavingsPlansPurchaseRecommendationDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SavingsPlansDetails] inside the given [block]
         */
        public fun savingsPlansDetails(block: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansDetails.Builder.() -> kotlin.Unit) {
            this.savingsPlansDetails = aws.sdk.kotlin.services.costexplorer.model.SavingsPlansDetails.invoke(block)
        }
    }
}
