// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Contains your request parameters, Savings Plan Recommendations Summary, and Details.
 */
public class SavingsPlansPurchaseRecommendation private constructor(builder: Builder) {
    /**
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations that include the management account and member accounts if the value is set to `PAYER`. If the value is `LINKED`, recommendations are calculated for individual member accounts only.
     */
    public val accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = builder.accountScope
    /**
     * The lookback period in days that's used to generate the recommendation.
     */
    public val lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = builder.lookbackPeriodInDays
    /**
     * The payment option that's used to generate the recommendation.
     */
    public val paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = builder.paymentOption
    /**
     * Details for the Savings Plans that we recommend that you purchase to cover existing Savings Plans eligible workloads.
     */
    public val savingsPlansPurchaseRecommendationDetails: List<SavingsPlansPurchaseRecommendationDetail>? = builder.savingsPlansPurchaseRecommendationDetails
    /**
     * Summary metrics for your Savings Plans Recommendations.
     */
    public val savingsPlansPurchaseRecommendationSummary: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary? = builder.savingsPlansPurchaseRecommendationSummary
    /**
     * The requested Savings Plans recommendation type.
     */
    public val savingsPlansType: aws.sdk.kotlin.services.costexplorer.model.SupportedSavingsPlansType? = builder.savingsPlansType
    /**
     * The Savings Plans recommendation term in years. It's used to generate the recommendation.
     */
    public val termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = builder.termInYears

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SavingsPlansPurchaseRecommendation(")
        append("accountScope=$accountScope,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("paymentOption=$paymentOption,")
        append("savingsPlansPurchaseRecommendationDetails=$savingsPlansPurchaseRecommendationDetails,")
        append("savingsPlansPurchaseRecommendationSummary=$savingsPlansPurchaseRecommendationSummary,")
        append("savingsPlansType=$savingsPlansType,")
        append("termInYears=$termInYears)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountScope?.hashCode() ?: 0
        result = 31 * result + (lookbackPeriodInDays?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (savingsPlansPurchaseRecommendationDetails?.hashCode() ?: 0)
        result = 31 * result + (savingsPlansPurchaseRecommendationSummary?.hashCode() ?: 0)
        result = 31 * result + (savingsPlansType?.hashCode() ?: 0)
        result = 31 * result + (termInYears?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SavingsPlansPurchaseRecommendation

        if (accountScope != other.accountScope) return false
        if (lookbackPeriodInDays != other.lookbackPeriodInDays) return false
        if (paymentOption != other.paymentOption) return false
        if (savingsPlansPurchaseRecommendationDetails != other.savingsPlansPurchaseRecommendationDetails) return false
        if (savingsPlansPurchaseRecommendationSummary != other.savingsPlansPurchaseRecommendationSummary) return false
        if (savingsPlansType != other.savingsPlansType) return false
        if (termInYears != other.termInYears) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations that include the management account and member accounts if the value is set to `PAYER`. If the value is `LINKED`, recommendations are calculated for individual member accounts only.
         */
        public var accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = null
        /**
         * The lookback period in days that's used to generate the recommendation.
         */
        public var lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = null
        /**
         * The payment option that's used to generate the recommendation.
         */
        public var paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = null
        /**
         * Details for the Savings Plans that we recommend that you purchase to cover existing Savings Plans eligible workloads.
         */
        public var savingsPlansPurchaseRecommendationDetails: List<SavingsPlansPurchaseRecommendationDetail>? = null
        /**
         * Summary metrics for your Savings Plans Recommendations.
         */
        public var savingsPlansPurchaseRecommendationSummary: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary? = null
        /**
         * The requested Savings Plans recommendation type.
         */
        public var savingsPlansType: aws.sdk.kotlin.services.costexplorer.model.SupportedSavingsPlansType? = null
        /**
         * The Savings Plans recommendation term in years. It's used to generate the recommendation.
         */
        public var termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendation) : this() {
            this.accountScope = x.accountScope
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.paymentOption = x.paymentOption
            this.savingsPlansPurchaseRecommendationDetails = x.savingsPlansPurchaseRecommendationDetails
            this.savingsPlansPurchaseRecommendationSummary = x.savingsPlansPurchaseRecommendationSummary
            this.savingsPlansType = x.savingsPlansType
            this.termInYears = x.termInYears
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendation = SavingsPlansPurchaseRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary] inside the given [block]
         */
        public fun savingsPlansPurchaseRecommendationSummary(block: aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.Builder.() -> kotlin.Unit) {
            this.savingsPlansPurchaseRecommendationSummary = aws.sdk.kotlin.services.costexplorer.model.SavingsPlansPurchaseRecommendationSummary.invoke(block)
        }
    }
}
