// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * A specific reservation that Amazon Web Services recommends for purchase.
 */
public class ReservationPurchaseRecommendation private constructor(builder: Builder) {
    /**
     * The account scope that Amazon Web Services recommends that you purchase this instance for. For example, you can purchase this reservation for an entire organization in Amazon Web Services Organizations.
     */
    public val accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = builder.accountScope
    /**
     * How many days of previous usage that Amazon Web Services considers when making this recommendation.
     */
    public val lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = builder.lookbackPeriodInDays
    /**
     * The payment option for the reservation (for example, `AllUpfront` or `NoUpfront`).
     */
    public val paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = builder.paymentOption
    /**
     * Details about the recommended purchases.
     */
    public val recommendationDetails: List<ReservationPurchaseRecommendationDetail>? = builder.recommendationDetails
    /**
     * A summary about the recommended purchase.
     */
    public val recommendationSummary: aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendationSummary? = builder.recommendationSummary
    /**
     * Hardware specifications for the service that you want recommendations for.
     */
    public val serviceSpecification: aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification? = builder.serviceSpecification
    /**
     * The term of the reservation that you want recommendations for, in years.
     */
    public val termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = builder.termInYears

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservationPurchaseRecommendation(")
        append("accountScope=$accountScope,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("paymentOption=$paymentOption,")
        append("recommendationDetails=$recommendationDetails,")
        append("recommendationSummary=$recommendationSummary,")
        append("serviceSpecification=$serviceSpecification,")
        append("termInYears=$termInYears)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountScope?.hashCode() ?: 0
        result = 31 * result + (lookbackPeriodInDays?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (recommendationDetails?.hashCode() ?: 0)
        result = 31 * result + (recommendationSummary?.hashCode() ?: 0)
        result = 31 * result + (serviceSpecification?.hashCode() ?: 0)
        result = 31 * result + (termInYears?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservationPurchaseRecommendation

        if (accountScope != other.accountScope) return false
        if (lookbackPeriodInDays != other.lookbackPeriodInDays) return false
        if (paymentOption != other.paymentOption) return false
        if (recommendationDetails != other.recommendationDetails) return false
        if (recommendationSummary != other.recommendationSummary) return false
        if (serviceSpecification != other.serviceSpecification) return false
        if (termInYears != other.termInYears) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account scope that Amazon Web Services recommends that you purchase this instance for. For example, you can purchase this reservation for an entire organization in Amazon Web Services Organizations.
         */
        public var accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = null
        /**
         * How many days of previous usage that Amazon Web Services considers when making this recommendation.
         */
        public var lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = null
        /**
         * The payment option for the reservation (for example, `AllUpfront` or `NoUpfront`).
         */
        public var paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = null
        /**
         * Details about the recommended purchases.
         */
        public var recommendationDetails: List<ReservationPurchaseRecommendationDetail>? = null
        /**
         * A summary about the recommended purchase.
         */
        public var recommendationSummary: aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendationSummary? = null
        /**
         * Hardware specifications for the service that you want recommendations for.
         */
        public var serviceSpecification: aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification? = null
        /**
         * The term of the reservation that you want recommendations for, in years.
         */
        public var termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendation) : this() {
            this.accountScope = x.accountScope
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.paymentOption = x.paymentOption
            this.recommendationDetails = x.recommendationDetails
            this.recommendationSummary = x.recommendationSummary
            this.serviceSpecification = x.serviceSpecification
            this.termInYears = x.termInYears
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendation = ReservationPurchaseRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendationSummary] inside the given [block]
         */
        public fun recommendationSummary(block: aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendationSummary.Builder.() -> kotlin.Unit) {
            this.recommendationSummary = aws.sdk.kotlin.services.costexplorer.model.ReservationPurchaseRecommendationSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification] inside the given [block]
         */
        public fun serviceSpecification(block: aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification.Builder.() -> kotlin.Unit) {
            this.serviceSpecification = aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification.invoke(block)
        }
    }
}
