// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Details about the Amazon RDS instances that Amazon Web Services recommends that you purchase.
 */
public class RdsInstanceDetails private constructor(builder: Builder) {
    /**
     * Determines whether the recommendation is for a current-generation instance.
     */
    public val currentGeneration: kotlin.Boolean = builder.currentGeneration
    /**
     * The database edition that the recommended reservation supports.
     */
    public val databaseEdition: kotlin.String? = builder.databaseEdition
    /**
     * The database engine that the recommended reservation supports.
     */
    public val databaseEngine: kotlin.String? = builder.databaseEngine
    /**
     * Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.
     */
    public val deploymentOption: kotlin.String? = builder.deploymentOption
    /**
     * The instance family of the recommended reservation.
     */
    public val family: kotlin.String? = builder.family
    /**
     * The type of instance that Amazon Web Services recommends.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The license model that the recommended reservation supports.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The Amazon Web Services Region of the recommended reservation.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Determines whether the recommended reservation is size flexible.
     */
    public val sizeFlexEligible: kotlin.Boolean = builder.sizeFlexEligible

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.RdsInstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsInstanceDetails(")
        append("currentGeneration=$currentGeneration,")
        append("databaseEdition=$databaseEdition,")
        append("databaseEngine=$databaseEngine,")
        append("deploymentOption=$deploymentOption,")
        append("family=$family,")
        append("instanceType=$instanceType,")
        append("licenseModel=$licenseModel,")
        append("region=$region,")
        append("sizeFlexEligible=$sizeFlexEligible)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentGeneration.hashCode()
        result = 31 * result + (databaseEdition?.hashCode() ?: 0)
        result = 31 * result + (databaseEngine?.hashCode() ?: 0)
        result = 31 * result + (deploymentOption?.hashCode() ?: 0)
        result = 31 * result + (family?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (sizeFlexEligible.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsInstanceDetails

        if (currentGeneration != other.currentGeneration) return false
        if (databaseEdition != other.databaseEdition) return false
        if (databaseEngine != other.databaseEngine) return false
        if (deploymentOption != other.deploymentOption) return false
        if (family != other.family) return false
        if (instanceType != other.instanceType) return false
        if (licenseModel != other.licenseModel) return false
        if (region != other.region) return false
        if (sizeFlexEligible != other.sizeFlexEligible) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.RdsInstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether the recommendation is for a current-generation instance.
         */
        public var currentGeneration: kotlin.Boolean = false
        /**
         * The database edition that the recommended reservation supports.
         */
        public var databaseEdition: kotlin.String? = null
        /**
         * The database engine that the recommended reservation supports.
         */
        public var databaseEngine: kotlin.String? = null
        /**
         * Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.
         */
        public var deploymentOption: kotlin.String? = null
        /**
         * The instance family of the recommended reservation.
         */
        public var family: kotlin.String? = null
        /**
         * The type of instance that Amazon Web Services recommends.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The license model that the recommended reservation supports.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the recommended reservation.
         */
        public var region: kotlin.String? = null
        /**
         * Determines whether the recommended reservation is size flexible.
         */
        public var sizeFlexEligible: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.RdsInstanceDetails) : this() {
            this.currentGeneration = x.currentGeneration
            this.databaseEdition = x.databaseEdition
            this.databaseEngine = x.databaseEngine
            this.deploymentOption = x.deploymentOption
            this.family = x.family
            this.instanceType = x.instanceType
            this.licenseModel = x.licenseModel
            this.region = x.region
            this.sizeFlexEligible = x.sizeFlexEligible
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.RdsInstanceDetails = RdsInstanceDetails(this)
    }
}
