// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetSavingsPlansUtilizationRequest private constructor(builder: Builder) {
    /**
     * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:
     * + `LINKED_ACCOUNT`
     * + `SAVINGS_PLAN_ARN`
     * + `SAVINGS_PLANS_TYPE`
     * + `REGION`
     * + `PAYMENT_OPTION`
     * + `INSTANCE_TYPE_FAMILY`
     *
     * `GetSavingsPlansUtilization` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * The granularity of the Amazon Web Services utillization data for your Savings Plans.
     *
     * The `GetSavingsPlansUtilization` operation supports only `DAILY` and `MONTHLY` granularities.
     */
    public val granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = builder.granularity
    /**
     * The value that you want to sort the data by.
     *
     * The following values are supported for `Key`:
     * + `UtilizationPercentage`
     * + `TotalCommitment`
     * + `UsedCommitment`
     * + `UnusedCommitment`
     * + `NetSavings`
     *
     * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
     */
    public val sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = builder.sortBy
    /**
     * The time period that you want the usage and costs for. The `Start` date must be within 13 months. The `End` date must be after the `Start` date, and before the current date. Future dates can't be used as an `End` date.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSavingsPlansUtilizationRequest(")
        append("filter=$filter,")
        append("granularity=$granularity,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (granularity?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSavingsPlansUtilizationRequest

        if (filter != other.filter) return false
        if (granularity != other.granularity) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:
         * + `LINKED_ACCOUNT`
         * + `SAVINGS_PLAN_ARN`
         * + `SAVINGS_PLANS_TYPE`
         * + `REGION`
         * + `PAYMENT_OPTION`
         * + `INSTANCE_TYPE_FAMILY`
         *
         * `GetSavingsPlansUtilization` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The granularity of the Amazon Web Services utillization data for your Savings Plans.
         *
         * The `GetSavingsPlansUtilization` operation supports only `DAILY` and `MONTHLY` granularities.
         */
        public var granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = null
        /**
         * The value that you want to sort the data by.
         *
         * The following values are supported for `Key`:
         * + `UtilizationPercentage`
         * + `TotalCommitment`
         * + `UsedCommitment`
         * + `UnusedCommitment`
         * + `NetSavings`
         *
         * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
         */
        public var sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = null
        /**
         * The time period that you want the usage and costs for. The `Start` date must be within 13 months. The `End` date must be after the `Start` date, and before the current date. Future dates can't be used as an `End` date.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationRequest) : this() {
            this.filter = x.filter
            this.granularity = x.granularity
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationRequest = GetSavingsPlansUtilizationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SortDefinition] inside the given [block]
         */
        public fun sortBy(block: aws.sdk.kotlin.services.costexplorer.model.SortDefinition.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.costexplorer.model.SortDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
