// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetSavingsPlansUtilizationDetailsRequest private constructor(builder: Builder) {
    /**
     * The data type.
     */
    public val dataType: List<SavingsPlansDataType>? = builder.dataType
    /**
     * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:
     * + `LINKED_ACCOUNT`
     * + `SAVINGS_PLAN_ARN`
     * + `REGION`
     * + `PAYMENT_OPTION`
     * + `INSTANCE_TYPE_FAMILY`
     *
     * `GetSavingsPlansUtilizationDetails` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * The number of items to be returned in a response. The default is `20`, with a minimum value of `1`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The value that you want to sort the data by.
     *
     * The following values are supported for `Key`:
     * + `UtilizationPercentage`
     * + `TotalCommitment`
     * + `UsedCommitment`
     * + `UnusedCommitment`
     * + `NetSavings`
     * + `AmortizedRecurringCommitment`
     * + `AmortizedUpfrontCommitment`
     *
     * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
     */
    public val sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = builder.sortBy
    /**
     * The time period that you want the usage and costs for. The `Start` date must be within 13 months. The `End` date must be after the `Start` date, and before the current date. Future dates can't be used as an `End` date.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSavingsPlansUtilizationDetailsRequest(")
        append("dataType=$dataType,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataType?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSavingsPlansUtilizationDetailsRequest

        if (dataType != other.dataType) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data type.
         */
        public var dataType: List<SavingsPlansDataType>? = null
        /**
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:
         * + `LINKED_ACCOUNT`
         * + `SAVINGS_PLAN_ARN`
         * + `REGION`
         * + `PAYMENT_OPTION`
         * + `INSTANCE_TYPE_FAMILY`
         *
         * `GetSavingsPlansUtilizationDetails` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The number of items to be returned in a response. The default is `20`, with a minimum value of `1`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The value that you want to sort the data by.
         *
         * The following values are supported for `Key`:
         * + `UtilizationPercentage`
         * + `TotalCommitment`
         * + `UsedCommitment`
         * + `UnusedCommitment`
         * + `NetSavings`
         * + `AmortizedRecurringCommitment`
         * + `AmortizedUpfrontCommitment`
         *
         * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
         */
        public var sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = null
        /**
         * The time period that you want the usage and costs for. The `Start` date must be within 13 months. The `End` date must be after the `Start` date, and before the current date. Future dates can't be used as an `End` date.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest) : this() {
            this.dataType = x.dataType
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest = GetSavingsPlansUtilizationDetailsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SortDefinition] inside the given [block]
         */
        public fun sortBy(block: aws.sdk.kotlin.services.costexplorer.model.SortDefinition.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.costexplorer.model.SortDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
