// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetSavingsPlansPurchaseRecommendationRequest private constructor(builder: Builder) {
    /**
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to `PAYER`. If the value is `LINKED`, recommendations are calculated for individual member accounts only.
     */
    public val accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = builder.accountScope
    /**
     * You can filter your recommendations by Account ID with the `LINKED_ACCOUNT` dimension. To filter your recommendations by Account ID, specify `Key` as `LINKED_ACCOUNT` and `Value` as the comma-separated Acount ID(s) that you want to see Savings Plans purchase recommendations for.
     *
     * For GetSavingsPlansPurchaseRecommendation, the `Filter` doesn't include `CostCategories` or `Tags`. It only includes `Dimensions`. With `Dimensions`, `Key` must be `LINKED_ACCOUNT` and `Value` can be a single Account ID or multiple comma-separated Account IDs that you want to see Savings Plans Purchase Recommendations for. `AND` and `OR` operators are not supported.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * The lookback period that's used to generate the recommendation.
     */
    public val lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = builder.lookbackPeriodInDays
    /**
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The number of recommendations that you want returned in a single response object.
     */
    public val pageSize: kotlin.Int = builder.pageSize
    /**
     * The payment option that's used to generate these recommendations.
     */
    public val paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = builder.paymentOption
    /**
     * The Savings Plans recommendation type that's requested.
     */
    public val savingsPlansType: aws.sdk.kotlin.services.costexplorer.model.SupportedSavingsPlansType? = builder.savingsPlansType
    /**
     * The savings plan recommendation term that's used to generate these recommendations.
     */
    public val termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = builder.termInYears

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSavingsPlansPurchaseRecommendationRequest(")
        append("accountScope=$accountScope,")
        append("filter=$filter,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("nextPageToken=$nextPageToken,")
        append("pageSize=$pageSize,")
        append("paymentOption=$paymentOption,")
        append("savingsPlansType=$savingsPlansType,")
        append("termInYears=$termInYears)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountScope?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays?.hashCode() ?: 0)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (pageSize)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (savingsPlansType?.hashCode() ?: 0)
        result = 31 * result + (termInYears?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSavingsPlansPurchaseRecommendationRequest

        if (accountScope != other.accountScope) return false
        if (filter != other.filter) return false
        if (lookbackPeriodInDays != other.lookbackPeriodInDays) return false
        if (nextPageToken != other.nextPageToken) return false
        if (pageSize != other.pageSize) return false
        if (paymentOption != other.paymentOption) return false
        if (savingsPlansType != other.savingsPlansType) return false
        if (termInYears != other.termInYears) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to `PAYER`. If the value is `LINKED`, recommendations are calculated for individual member accounts only.
         */
        public var accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = null
        /**
         * You can filter your recommendations by Account ID with the `LINKED_ACCOUNT` dimension. To filter your recommendations by Account ID, specify `Key` as `LINKED_ACCOUNT` and `Value` as the comma-separated Acount ID(s) that you want to see Savings Plans purchase recommendations for.
         *
         * For GetSavingsPlansPurchaseRecommendation, the `Filter` doesn't include `CostCategories` or `Tags`. It only includes `Dimensions`. With `Dimensions`, `Key` must be `LINKED_ACCOUNT` and `Value` can be a single Account ID or multiple comma-separated Account IDs that you want to see Savings Plans Purchase Recommendations for. `AND` and `OR` operators are not supported.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The lookback period that's used to generate the recommendation.
         */
        public var lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = null
        /**
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The number of recommendations that you want returned in a single response object.
         */
        public var pageSize: kotlin.Int = 0
        /**
         * The payment option that's used to generate these recommendations.
         */
        public var paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = null
        /**
         * The Savings Plans recommendation type that's requested.
         */
        public var savingsPlansType: aws.sdk.kotlin.services.costexplorer.model.SupportedSavingsPlansType? = null
        /**
         * The savings plan recommendation term that's used to generate these recommendations.
         */
        public var termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest) : this() {
            this.accountScope = x.accountScope
            this.filter = x.filter
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.nextPageToken = x.nextPageToken
            this.pageSize = x.pageSize
            this.paymentOption = x.paymentOption
            this.savingsPlansType = x.savingsPlansType
            this.termInYears = x.termInYears
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest = GetSavingsPlansPurchaseRecommendationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }
    }
}
