// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetSavingsPlansCoverageRequest private constructor(builder: Builder) {
    /**
     * Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:
     * + `LINKED_ACCOUNT`
     * + `REGION`
     * + `SERVICE`
     * + `INSTANCE_FAMILY`
     *
     * `GetSavingsPlansCoverage` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension. If there are multiple values for a dimension, they are OR'd together.
     *
     * Cost category is also supported.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * The granularity of the Amazon Web Services cost data for your Savings Plans. `Granularity` can't be set if `GroupBy` is set.
     *
     * The `GetSavingsPlansCoverage` operation supports only `DAILY` and `MONTHLY` granularities.
     */
    public val granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = builder.granularity
    /**
     * You can group the data using the attributes `INSTANCE_FAMILY`, `REGION`, or `SERVICE`.
     */
    public val groupBy: List<GroupDefinition>? = builder.groupBy
    /**
     * The number of items to be returned in a response. The default is `20`, with a minimum value of `1`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The measurement that you want your Savings Plans coverage reported in. The only valid value is `SpendCoveredBySavingsPlans`.
     */
    public val metrics: List<String>? = builder.metrics
    /**
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The value that you want to sort the data by.
     *
     * The following values are supported for `Key`:
     * + `SpendCoveredBySavingsPlan`
     * + `OnDemandCost`
     * + `CoveragePercentage`
     * + `TotalCost`
     * + `InstanceFamily`
     * + `Region`
     * + `Service`
     *
     * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
     */
    public val sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = builder.sortBy
    /**
     * The time period that you want the usage and costs for. The `Start` date must be within 13 months. The `End` date must be after the `Start` date, and before the current date. Future dates can't be used as an `End` date.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSavingsPlansCoverageRequest(")
        append("filter=$filter,")
        append("granularity=$granularity,")
        append("groupBy=$groupBy,")
        append("maxResults=$maxResults,")
        append("metrics=$metrics,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (granularity?.hashCode() ?: 0)
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSavingsPlansCoverageRequest

        if (filter != other.filter) return false
        if (granularity != other.granularity) return false
        if (groupBy != other.groupBy) return false
        if (maxResults != other.maxResults) return false
        if (metrics != other.metrics) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:
         * + `LINKED_ACCOUNT`
         * + `REGION`
         * + `SERVICE`
         * + `INSTANCE_FAMILY`
         *
         * `GetSavingsPlansCoverage` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension. If there are multiple values for a dimension, they are OR'd together.
         *
         * Cost category is also supported.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The granularity of the Amazon Web Services cost data for your Savings Plans. `Granularity` can't be set if `GroupBy` is set.
         *
         * The `GetSavingsPlansCoverage` operation supports only `DAILY` and `MONTHLY` granularities.
         */
        public var granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = null
        /**
         * You can group the data using the attributes `INSTANCE_FAMILY`, `REGION`, or `SERVICE`.
         */
        public var groupBy: List<GroupDefinition>? = null
        /**
         * The number of items to be returned in a response. The default is `20`, with a minimum value of `1`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The measurement that you want your Savings Plans coverage reported in. The only valid value is `SpendCoveredBySavingsPlans`.
         */
        public var metrics: List<String>? = null
        /**
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The value that you want to sort the data by.
         *
         * The following values are supported for `Key`:
         * + `SpendCoveredBySavingsPlan`
         * + `OnDemandCost`
         * + `CoveragePercentage`
         * + `TotalCost`
         * + `InstanceFamily`
         * + `Region`
         * + `Service`
         *
         * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
         */
        public var sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = null
        /**
         * The time period that you want the usage and costs for. The `Start` date must be within 13 months. The `End` date must be after the `Start` date, and before the current date. Future dates can't be used as an `End` date.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageRequest) : this() {
            this.filter = x.filter
            this.granularity = x.granularity
            this.groupBy = x.groupBy
            this.maxResults = x.maxResults
            this.metrics = x.metrics
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageRequest = GetSavingsPlansCoverageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SortDefinition] inside the given [block]
         */
        public fun sortBy(block: aws.sdk.kotlin.services.costexplorer.model.SortDefinition.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.costexplorer.model.SortDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
