// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetReservationUtilizationRequest private constructor(builder: Builder) {
    /**
     * Filters utilization data by dimensions. You can filter by the following dimensions:
     * + AZ
     * + CACHE_ENGINE
     * + DEPLOYMENT_OPTION
     * + INSTANCE_TYPE
     * + LINKED_ACCOUNT
     * + OPERATING_SYSTEM
     * + PLATFORM
     * + REGION
     * + SERVICE
     * + SCOPE
     * + TENANCY
     *
     * `GetReservationUtilization` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension, and nesting is supported up to only one level deep. If there are multiple values for a dimension, they are OR'd together.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't set, the response object doesn't include `Granularity`, either `MONTHLY` or `DAILY`. If both `GroupBy` and `Granularity` aren't set, `GetReservationUtilization` defaults to `DAILY`.
     *
     * The `GetReservationUtilization` operation supports only `DAILY` and `MONTHLY` granularities.
     */
    public val granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = builder.granularity
    /**
     * Groups only by `SUBSCRIPTION_ID`. Metadata is included.
     */
    public val groupBy: List<GroupDefinition>? = builder.groupBy
    /**
     * The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The value that you want to sort the data by.
     *
     * The following values are supported for `Key`:
     * + `UtilizationPercentage`
     * + `UtilizationPercentageInUnits`
     * + `PurchasedHours`
     * + `PurchasedUnits`
     * + `TotalActualHours`
     * + `TotalActualUnits`
     * + `UnusedHours`
     * + `UnusedUnits`
     * + `OnDemandCostOfRIHoursUsed`
     * + `NetRISavings`
     * + `TotalPotentialRISavings`
     * + `AmortizedUpfrontFee`
     * + `AmortizedRecurringFee`
     * + `TotalAmortizedFee`
     * + `RICostForUnusedHours`
     * + `RealizedSavings`
     * + `UnrealizedSavings`
     *
     * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
     */
    public val sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = builder.sortBy
    /**
     * Sets the start and end dates for retrieving Reserved Instance (RI) utilization. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetReservationUtilizationRequest(")
        append("filter=$filter,")
        append("granularity=$granularity,")
        append("groupBy=$groupBy,")
        append("maxResults=$maxResults,")
        append("nextPageToken=$nextPageToken,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (granularity?.hashCode() ?: 0)
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetReservationUtilizationRequest

        if (filter != other.filter) return false
        if (granularity != other.granularity) return false
        if (groupBy != other.groupBy) return false
        if (maxResults != other.maxResults) return false
        if (nextPageToken != other.nextPageToken) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters utilization data by dimensions. You can filter by the following dimensions:
         * + AZ
         * + CACHE_ENGINE
         * + DEPLOYMENT_OPTION
         * + INSTANCE_TYPE
         * + LINKED_ACCOUNT
         * + OPERATING_SYSTEM
         * + PLATFORM
         * + REGION
         * + SERVICE
         * + SCOPE
         * + TENANCY
         *
         * `GetReservationUtilization` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension, and nesting is supported up to only one level deep. If there are multiple values for a dimension, they are OR'd together.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't set, the response object doesn't include `Granularity`, either `MONTHLY` or `DAILY`. If both `GroupBy` and `Granularity` aren't set, `GetReservationUtilization` defaults to `DAILY`.
         *
         * The `GetReservationUtilization` operation supports only `DAILY` and `MONTHLY` granularities.
         */
        public var granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = null
        /**
         * Groups only by `SUBSCRIPTION_ID`. Metadata is included.
         */
        public var groupBy: List<GroupDefinition>? = null
        /**
         * The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The value that you want to sort the data by.
         *
         * The following values are supported for `Key`:
         * + `UtilizationPercentage`
         * + `UtilizationPercentageInUnits`
         * + `PurchasedHours`
         * + `PurchasedUnits`
         * + `TotalActualHours`
         * + `TotalActualUnits`
         * + `UnusedHours`
         * + `UnusedUnits`
         * + `OnDemandCostOfRIHoursUsed`
         * + `NetRISavings`
         * + `TotalPotentialRISavings`
         * + `AmortizedUpfrontFee`
         * + `AmortizedRecurringFee`
         * + `TotalAmortizedFee`
         * + `RICostForUnusedHours`
         * + `RealizedSavings`
         * + `UnrealizedSavings`
         *
         * The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
         */
        public var sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = null
        /**
         * Sets the start and end dates for retrieving Reserved Instance (RI) utilization. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationRequest) : this() {
            this.filter = x.filter
            this.granularity = x.granularity
            this.groupBy = x.groupBy
            this.maxResults = x.maxResults
            this.nextPageToken = x.nextPageToken
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationRequest = GetReservationUtilizationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SortDefinition] inside the given [block]
         */
        public fun sortBy(block: aws.sdk.kotlin.services.costexplorer.model.SortDefinition.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.costexplorer.model.SortDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
