// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetReservationPurchaseRecommendationRequest private constructor(builder: Builder) {
    /**
     * The account ID that's associated with the recommendation.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to `PAYER`. If the value is `LINKED`, recommendations are calculated for individual member accounts only.
     */
    public val accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = builder.accountScope
    /**
     * Use `Expression` to filter by cost or by usage. There are two patterns:
     * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
     * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
     *
     * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
     *
     * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.
     */
    public val lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = builder.lookbackPeriodInDays
    /**
     * The pagination token that indicates the next set of results that you want to retrieve.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The number of recommendations that you want returned in a single response object.
     */
    public val pageSize: kotlin.Int = builder.pageSize
    /**
     * The reservation purchase option that you want recommendations for.
     */
    public val paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = builder.paymentOption
    /**
     * The specific service that you want recommendations for.
     */
    public val service: kotlin.String? = builder.service
    /**
     * The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.
     */
    public val serviceSpecification: aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification? = builder.serviceSpecification
    /**
     * The reservation term that you want recommendations for.
     */
    public val termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = builder.termInYears

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetReservationPurchaseRecommendationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetReservationPurchaseRecommendationRequest(")
        append("accountId=$accountId,")
        append("accountScope=$accountScope,")
        append("filter=$filter,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("nextPageToken=$nextPageToken,")
        append("pageSize=$pageSize,")
        append("paymentOption=$paymentOption,")
        append("service=$service,")
        append("serviceSpecification=$serviceSpecification,")
        append("termInYears=$termInYears)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (accountScope?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays?.hashCode() ?: 0)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (pageSize)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (serviceSpecification?.hashCode() ?: 0)
        result = 31 * result + (termInYears?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetReservationPurchaseRecommendationRequest

        if (accountId != other.accountId) return false
        if (accountScope != other.accountScope) return false
        if (filter != other.filter) return false
        if (lookbackPeriodInDays != other.lookbackPeriodInDays) return false
        if (nextPageToken != other.nextPageToken) return false
        if (pageSize != other.pageSize) return false
        if (paymentOption != other.paymentOption) return false
        if (service != other.service) return false
        if (serviceSpecification != other.serviceSpecification) return false
        if (termInYears != other.termInYears) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetReservationPurchaseRecommendationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account ID that's associated with the recommendation.
         */
        public var accountId: kotlin.String? = null
        /**
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to `PAYER`. If the value is `LINKED`, recommendations are calculated for individual member accounts only.
         */
        public var accountScope: aws.sdk.kotlin.services.costexplorer.model.AccountScope? = null
        /**
         * Use `Expression` to filter by cost or by usage. There are two patterns:
         * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
         * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
         *
         * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
         *
         * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.
         */
        public var lookbackPeriodInDays: aws.sdk.kotlin.services.costexplorer.model.LookbackPeriodInDays? = null
        /**
         * The pagination token that indicates the next set of results that you want to retrieve.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The number of recommendations that you want returned in a single response object.
         */
        public var pageSize: kotlin.Int = 0
        /**
         * The reservation purchase option that you want recommendations for.
         */
        public var paymentOption: aws.sdk.kotlin.services.costexplorer.model.PaymentOption? = null
        /**
         * The specific service that you want recommendations for.
         */
        public var service: kotlin.String? = null
        /**
         * The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.
         */
        public var serviceSpecification: aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification? = null
        /**
         * The reservation term that you want recommendations for.
         */
        public var termInYears: aws.sdk.kotlin.services.costexplorer.model.TermInYears? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetReservationPurchaseRecommendationRequest) : this() {
            this.accountId = x.accountId
            this.accountScope = x.accountScope
            this.filter = x.filter
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.nextPageToken = x.nextPageToken
            this.pageSize = x.pageSize
            this.paymentOption = x.paymentOption
            this.service = x.service
            this.serviceSpecification = x.serviceSpecification
            this.termInYears = x.termInYears
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetReservationPurchaseRecommendationRequest = GetReservationPurchaseRecommendationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification] inside the given [block]
         */
        public fun serviceSpecification(block: aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification.Builder.() -> kotlin.Unit) {
            this.serviceSpecification = aws.sdk.kotlin.services.costexplorer.model.ServiceSpecification.invoke(block)
        }
    }
}
