// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * You can use the following request parameters to query for how much of your instance usage a reservation covered.
 */
public class GetReservationCoverageRequest private constructor(builder: Builder) {
    /**
     * Filters utilization data by dimensions. You can filter by the following dimensions:
     * + AZ
     * + CACHE_ENGINE
     * + DATABASE_ENGINE
     * + DEPLOYMENT_OPTION
     * + INSTANCE_TYPE
     * + LINKED_ACCOUNT
     * + OPERATING_SYSTEM
     * + PLATFORM
     * + REGION
     * + SERVICE
     * + TAG
     * + TENANCY
     *
     * `GetReservationCoverage` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension. You can nest only one level deep. If there are multiple values for a dimension, they are OR'd together.
     *
     * If you don't provide a `SERVICE` filter, Cost Explorer defaults to EC2.
     *
     * Cost category is also supported.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * The granularity of the Amazon Web Services cost data for the reservation. Valid values are `MONTHLY` and `DAILY`.
     *
     * If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't set, the response object doesn't include `Granularity`, either `MONTHLY` or `DAILY`.
     *
     * The `GetReservationCoverage` operation supports only `DAILY` and `MONTHLY` granularities.
     */
    public val granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = builder.granularity
    /**
     * You can group the data by the following attributes:
     * + AZ
     * + CACHE_ENGINE
     * + DATABASE_ENGINE
     * + DEPLOYMENT_OPTION
     * + INSTANCE_TYPE
     * + INVOICING_ENTITY
     * + LINKED_ACCOUNT
     * + OPERATING_SYSTEM
     * + PLATFORM
     * + REGION
     * + TENANCY
     */
    public val groupBy: List<GroupDefinition>? = builder.groupBy
    /**
     * The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The measurement that you want your reservation coverage reported in.
     *
     * Valid values are `Hour`, `Unit`, and `Cost`. You can use multiple values in a request.
     */
    public val metrics: List<String>? = builder.metrics
    /**
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The value by which you want to sort the data.
     *
     * The following values are supported for `Key`:
     * + `OnDemandCost`
     * + `CoverageHoursPercentage`
     * + `OnDemandHours`
     * + `ReservedHours`
     * + `TotalRunningHours`
     * + `CoverageNormalizedUnitsPercentage`
     * + `OnDemandNormalizedUnits`
     * + `ReservedNormalizedUnits`
     * + `TotalRunningNormalizedUnits`
     * + `Time`
     *
     * Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
     */
    public val sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = builder.sortBy
    /**
     * The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetReservationCoverageRequest(")
        append("filter=$filter,")
        append("granularity=$granularity,")
        append("groupBy=$groupBy,")
        append("maxResults=$maxResults,")
        append("metrics=$metrics,")
        append("nextPageToken=$nextPageToken,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (granularity?.hashCode() ?: 0)
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetReservationCoverageRequest

        if (filter != other.filter) return false
        if (granularity != other.granularity) return false
        if (groupBy != other.groupBy) return false
        if (maxResults != other.maxResults) return false
        if (metrics != other.metrics) return false
        if (nextPageToken != other.nextPageToken) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters utilization data by dimensions. You can filter by the following dimensions:
         * + AZ
         * + CACHE_ENGINE
         * + DATABASE_ENGINE
         * + DEPLOYMENT_OPTION
         * + INSTANCE_TYPE
         * + LINKED_ACCOUNT
         * + OPERATING_SYSTEM
         * + PLATFORM
         * + REGION
         * + SERVICE
         * + TAG
         * + TENANCY
         *
         * `GetReservationCoverage` uses the same [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object as the other operations, but only `AND` is supported among each dimension. You can nest only one level deep. If there are multiple values for a dimension, they are OR'd together.
         *
         * If you don't provide a `SERVICE` filter, Cost Explorer defaults to EC2.
         *
         * Cost category is also supported.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The granularity of the Amazon Web Services cost data for the reservation. Valid values are `MONTHLY` and `DAILY`.
         *
         * If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't set, the response object doesn't include `Granularity`, either `MONTHLY` or `DAILY`.
         *
         * The `GetReservationCoverage` operation supports only `DAILY` and `MONTHLY` granularities.
         */
        public var granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = null
        /**
         * You can group the data by the following attributes:
         * + AZ
         * + CACHE_ENGINE
         * + DATABASE_ENGINE
         * + DEPLOYMENT_OPTION
         * + INSTANCE_TYPE
         * + INVOICING_ENTITY
         * + LINKED_ACCOUNT
         * + OPERATING_SYSTEM
         * + PLATFORM
         * + REGION
         * + TENANCY
         */
        public var groupBy: List<GroupDefinition>? = null
        /**
         * The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The measurement that you want your reservation coverage reported in.
         *
         * Valid values are `Hour`, `Unit`, and `Cost`. You can use multiple values in a request.
         */
        public var metrics: List<String>? = null
        /**
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The value by which you want to sort the data.
         *
         * The following values are supported for `Key`:
         * + `OnDemandCost`
         * + `CoverageHoursPercentage`
         * + `OnDemandHours`
         * + `ReservedHours`
         * + `TotalRunningHours`
         * + `CoverageNormalizedUnitsPercentage`
         * + `OnDemandNormalizedUnits`
         * + `ReservedNormalizedUnits`
         * + `TotalRunningNormalizedUnits`
         * + `Time`
         *
         * Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
         */
        public var sortBy: aws.sdk.kotlin.services.costexplorer.model.SortDefinition? = null
        /**
         * The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageRequest) : this() {
            this.filter = x.filter
            this.granularity = x.granularity
            this.groupBy = x.groupBy
            this.maxResults = x.maxResults
            this.metrics = x.metrics
            this.nextPageToken = x.nextPageToken
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageRequest = GetReservationCoverageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.SortDefinition] inside the given [block]
         */
        public fun sortBy(block: aws.sdk.kotlin.services.costexplorer.model.SortDefinition.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.costexplorer.model.SortDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
