// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetDimensionValuesResponse private constructor(builder: Builder) {
    /**
     * The filters that you used to filter your request. Some dimensions are available only for a specific context.
     *
     * If you set the context to `COST_AND_USAGE`, you can use the following dimensions for searching:
     * + AZ - The Availability Zone. An example is `us-east-1a`.
     * + DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
     * + LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.
     * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
     * + OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * + OPERATION - The action performed. Examples include `RunInstance` and `CreateBucket`.
     * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * + PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.
     * + SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     * + USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the `GetDimensionValues` operation includes a unit attribute. Examples include GB and Hrs.
     * + USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.
     * + RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     * + RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service. You can opt-in by enabling `Hourly` and `Resource Level Data` in Cost Management Console preferences.
     *
     * If you set the context to `RESERVATIONS`, you can use the following dimensions for searching:
     * + AZ - The Availability Zone. An example is `us-east-1a`.
     * + CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * + DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are `SingleAZ` and `MultiAZ`.
     * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
     * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
     * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * + REGION - The Amazon Web Services Region.
     * + SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.
     * + TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * + TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *
     * If you set the context to `SAVINGS_PLANS`, you can use the following dimensions for searching:
     * + SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * + PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     * + REGION - The Amazon Web Services Region.
     * + INSTANCE_TYPE_FAMILY - The family of instances (For example, `m5`)
     * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
     * + SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     */
    public val dimensionValues: List<DimensionValuesWithAttributes>? = builder.dimensionValues
    /**
     * The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The number of results that Amazon Web Services returned at one time.
     */
    public val returnSize: kotlin.Int? = builder.returnSize
    /**
     * The total number of search results.
     */
    public val totalSize: kotlin.Int? = builder.totalSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDimensionValuesResponse(")
        append("dimensionValues=$dimensionValues,")
        append("nextPageToken=$nextPageToken,")
        append("returnSize=$returnSize,")
        append("totalSize=$totalSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensionValues?.hashCode() ?: 0
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (returnSize ?: 0)
        result = 31 * result + (totalSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDimensionValuesResponse

        if (dimensionValues != other.dimensionValues) return false
        if (nextPageToken != other.nextPageToken) return false
        if (returnSize != other.returnSize) return false
        if (totalSize != other.totalSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters that you used to filter your request. Some dimensions are available only for a specific context.
         *
         * If you set the context to `COST_AND_USAGE`, you can use the following dimensions for searching:
         * + AZ - The Availability Zone. An example is `us-east-1a`.
         * + DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
         * + LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.
         * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
         * + OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * + OPERATION - The action performed. Examples include `RunInstance` and `CreateBucket`.
         * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * + PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.
         * + SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * + USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the `GetDimensionValues` operation includes a unit attribute. Examples include GB and Hrs.
         * + USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.
         * + RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * + RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service. You can opt-in by enabling `Hourly` and `Resource Level Data` in Cost Management Console preferences.
         *
         * If you set the context to `RESERVATIONS`, you can use the following dimensions for searching:
         * + AZ - The Availability Zone. An example is `us-east-1a`.
         * + CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * + DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are `SingleAZ` and `MultiAZ`.
         * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
         * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
         * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * + REGION - The Amazon Web Services Region.
         * + SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.
         * + TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * + TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *
         * If you set the context to `SAVINGS_PLANS`, you can use the following dimensions for searching:
         * + SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * + PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * + REGION - The Amazon Web Services Region.
         * + INSTANCE_TYPE_FAMILY - The family of instances (For example, `m5`)
         * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
         * + SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         */
        public var dimensionValues: List<DimensionValuesWithAttributes>? = null
        /**
         * The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The number of results that Amazon Web Services returned at one time.
         */
        public var returnSize: kotlin.Int? = null
        /**
         * The total number of search results.
         */
        public var totalSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesResponse) : this() {
            this.dimensionValues = x.dimensionValues
            this.nextPageToken = x.nextPageToken
            this.returnSize = x.returnSize
            this.totalSize = x.totalSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesResponse = GetDimensionValuesResponse(this)
    }
}
