// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetDimensionValuesRequest private constructor(builder: Builder) {
    /**
     * The context for the call to `GetDimensionValues`. This can be `RESERVATIONS` or `COST_AND_USAGE`. The default value is `COST_AND_USAGE`. If the context is set to `RESERVATIONS`, the resulting dimension values can be used in the `GetReservationUtilization` operation. If the context is set to `COST_AND_USAGE`, the resulting dimension values can be used in the `GetCostAndUsage` operation.
     *
     * If you set the context to `COST_AND_USAGE`, you can use the following dimensions for searching:
     * + AZ - The Availability Zone. An example is `us-east-1a`.
     * + BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the following:- Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services.- AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that's an acting reseller for Amazon Web Services in India.- Amazon Web Services Marketplace: The entity that supports the sale of solutions that are built on Amazon Web Services by third-party software providers.
     * + CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * + DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are `SingleAZ` and `MultiAZ`.
     * + DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
     * + INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are `Compute Optimized` (for example, `C4`, `C5`, `C6g`, and `C7g`), `Memory Optimization` (for example, `R4`, `R5n`, `R5b`, and `R6g`).
     * + INVOICING_ENTITY - The name of the entity that issues the Amazon Web Services invoice.
     * + LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.
     * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
     * + OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * + OPERATION - The action performed. Examples include `RunInstance` and `CreateBucket`.
     * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * + PURCHASE_TYPE - The reservation type of the purchase that this usage is related to. Examples include On-Demand Instances and Standard Reserved Instances.
     * + RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
     * + SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     * + SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
     * + SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     * + TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * + USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the `GetDimensionValues` operation includes a unit attribute. Examples include GB and Hrs.
     * + USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.
     * + REGION - The Amazon Web Services Region.
     * + RECORD_TYPE - The different types of charges such as Reserved Instance (RI) fees, usage costs, tax refunds, and credits.
     * + RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.
     *
     * If you set the context to `RESERVATIONS`, you can use the following dimensions for searching:
     * + AZ - The Availability Zone. An example is `us-east-1a`.
     * + CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * + DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are `SingleAZ` and `MultiAZ`.
     * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
     * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
     * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * + REGION - The Amazon Web Services Region.
     * + SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.
     * + TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * + TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *
     * If you set the context to `SAVINGS_PLANS`, you can use the following dimensions for searching:
     * + SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * + PAYMENT_OPTION - The payment option for the given Savings Plans (for example, All Upfront)
     * + REGION - The Amazon Web Services Region.
     * + INSTANCE_TYPE_FAMILY - The family of instances (For example, `m5`)
     * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
     * + SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
     */
    public val context: aws.sdk.kotlin.services.costexplorer.model.Context? = builder.context
    /**
     * The name of the dimension. Each `Dimension` is available for a different `Context`. For more information, see `Context`. `LINK_ACCOUNT_NAME` and `SERVICE_CODE` can only be used in [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/AAPI_CostCategoryRule.html).
     */
    public val dimension: aws.sdk.kotlin.services.costexplorer.model.Dimension? = builder.dimension
    /**
     * Use `Expression` to filter by cost or by usage. There are two patterns:
     * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
     * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
     *
     * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
     *
     * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * This field is only used when SortBy is provided in the request. The maximum number of objects that are returned for this request. If MaxResults isn't specified with SortBy, the request returns 1000 results as the default value for this parameter.
     *
     * For `GetDimensionValues`, MaxResults has an upper limit of 1000.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The value that you want to search the filter values for.
     */
    public val searchString: kotlin.String? = builder.searchString
    /**
     * The value that you want to sort the data by.
     *
     * The key represents cost and usage metrics. The following values are supported:
     * + `BlendedCost`
     * + `UnblendedCost`
     * + `AmortizedCost`
     * + `NetAmortizedCost`
     * + `NetUnblendedCost`
     * + `UsageQuantity`
     * + `NormalizedUsageAmount`
     *
     * The supported values for the `SortOrder` key are `ASCENDING` or `DESCENDING`.
     *
     * When you specify a `SortBy` paramater, the context must be `COST_AND_USAGE`. Further, when using `SortBy`, `NextPageToken` and `SearchString` aren't supported.
     */
    public val sortBy: List<SortDefinition>? = builder.sortBy
    /**
     * The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDimensionValuesRequest(")
        append("context=$context,")
        append("dimension=$dimension,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextPageToken=$nextPageToken,")
        append("searchString=$searchString,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = context?.hashCode() ?: 0
        result = 31 * result + (dimension?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (searchString?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDimensionValuesRequest

        if (context != other.context) return false
        if (dimension != other.dimension) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextPageToken != other.nextPageToken) return false
        if (searchString != other.searchString) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The context for the call to `GetDimensionValues`. This can be `RESERVATIONS` or `COST_AND_USAGE`. The default value is `COST_AND_USAGE`. If the context is set to `RESERVATIONS`, the resulting dimension values can be used in the `GetReservationUtilization` operation. If the context is set to `COST_AND_USAGE`, the resulting dimension values can be used in the `GetCostAndUsage` operation.
         *
         * If you set the context to `COST_AND_USAGE`, you can use the following dimensions for searching:
         * + AZ - The Availability Zone. An example is `us-east-1a`.
         * + BILLING_ENTITY - The Amazon Web Services seller that your account is with. Possible values are the following:- Amazon Web Services(Amazon Web Services): The entity that sells Amazon Web Services.- AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian entity that's an acting reseller for Amazon Web Services in India.- Amazon Web Services Marketplace: The entity that supports the sale of solutions that are built on Amazon Web Services by third-party software providers.
         * + CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * + DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are `SingleAZ` and `MultiAZ`.
         * + DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
         * + INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit different use cases. Examples are `Compute Optimized` (for example, `C4`, `C5`, `C6g`, and `C7g`), `Memory Optimization` (for example, `R4`, `R5n`, `R5b`, and `R6g`).
         * + INVOICING_ENTITY - The name of the entity that issues the Amazon Web Services invoice.
         * + LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.
         * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
         * + OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * + OPERATION - The action performed. Examples include `RunInstance` and `CreateBucket`.
         * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * + PURCHASE_TYPE - The reservation type of the purchase that this usage is related to. Examples include On-Demand Instances and Standard Reserved Instances.
         * + RESERVATION_ID - The unique identifier for an Amazon Web Services Reservation Instance.
         * + SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         * + SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute).
         * + SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * + TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * + USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the `GetDimensionValues` operation includes a unit attribute. Examples include GB and Hrs.
         * + USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.
         * + REGION - The Amazon Web Services Region.
         * + RECORD_TYPE - The different types of charges such as Reserved Instance (RI) fees, usage costs, tax refunds, and credits.
         * + RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.
         *
         * If you set the context to `RESERVATIONS`, you can use the following dimensions for searching:
         * + AZ - The Availability Zone. An example is `us-east-1a`.
         * + CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * + DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are `SingleAZ` and `MultiAZ`.
         * + INSTANCE_TYPE - The type of Amazon EC2 instance. An example is `m4.xlarge`.
         * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
         * + PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * + REGION - The Amazon Web Services Region.
         * + SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.
         * + TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * + TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *
         * If you set the context to `SAVINGS_PLANS`, you can use the following dimensions for searching:
         * + SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * + PAYMENT_OPTION - The payment option for the given Savings Plans (for example, All Upfront)
         * + REGION - The Amazon Web Services Region.
         * + INSTANCE_TYPE_FAMILY - The family of instances (For example, `m5`)
         * + LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.
         * + SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
         */
        public var context: aws.sdk.kotlin.services.costexplorer.model.Context? = null
        /**
         * The name of the dimension. Each `Dimension` is available for a different `Context`. For more information, see `Context`. `LINK_ACCOUNT_NAME` and `SERVICE_CODE` can only be used in [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/AAPI_CostCategoryRule.html).
         */
        public var dimension: aws.sdk.kotlin.services.costexplorer.model.Dimension? = null
        /**
         * Use `Expression` to filter by cost or by usage. There are two patterns:
         * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
         * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
         *
         * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
         *
         * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * This field is only used when SortBy is provided in the request. The maximum number of objects that are returned for this request. If MaxResults isn't specified with SortBy, the request returns 1000 results as the default value for this parameter.
         *
         * For `GetDimensionValues`, MaxResults has an upper limit of 1000.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The value that you want to search the filter values for.
         */
        public var searchString: kotlin.String? = null
        /**
         * The value that you want to sort the data by.
         *
         * The key represents cost and usage metrics. The following values are supported:
         * + `BlendedCost`
         * + `UnblendedCost`
         * + `AmortizedCost`
         * + `NetAmortizedCost`
         * + `NetUnblendedCost`
         * + `UsageQuantity`
         * + `NormalizedUsageAmount`
         *
         * The supported values for the `SortOrder` key are `ASCENDING` or `DESCENDING`.
         *
         * When you specify a `SortBy` paramater, the context must be `COST_AND_USAGE`. Further, when using `SortBy`, `NextPageToken` and `SearchString` aren't supported.
         */
        public var sortBy: List<SortDefinition>? = null
        /**
         * The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesRequest) : this() {
            this.context = x.context
            this.dimension = x.dimension
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextPageToken = x.nextPageToken
            this.searchString = x.searchString
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesRequest = GetDimensionValuesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
