// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetCostForecastRequest private constructor(builder: Builder) {
    /**
     * The filters that you want to use to filter your forecast. The `GetCostForecast` API supports filtering by the following dimensions:
     * + `AZ`
     * + `INSTANCE_TYPE`
     * + `LINKED_ACCOUNT`
     * + `LINKED_ACCOUNT_NAME`
     * + `OPERATION`
     * + `PURCHASE_TYPE`
     * + `REGION`
     * + `SERVICE`
     * + `USAGE_TYPE`
     * + `USAGE_TYPE_GROUP`
     * + `RECORD_TYPE`
     * + `OPERATING_SYSTEM`
     * + `TENANCY`
     * + `SCOPE`
     * + `PLATFORM`
     * + `SUBSCRIPTION_ID`
     * + `LEGAL_ENTITY_NAME`
     * + `DEPLOYMENT_OPTION`
     * + `DATABASE_ENGINE`
     * + `INSTANCE_TYPE_FAMILY`
     * + `BILLING_ENTITY`
     * + `RESERVATION_ID`
     * + `SAVINGS_PLAN_ARN`
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * How granular you want the forecast to be. You can get 3 months of `DAILY` forecasts or 12 months of `MONTHLY` forecasts.
     *
     * The `GetCostForecast` operation supports only `DAILY` and `MONTHLY` granularities.
     */
    public val granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = builder.granularity
    /**
     * Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see [Why does the "blended" annotation appear on some line items in my bill?](http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
     *
     * Valid values for a `GetCostForecast` call are the following:
     * + AMORTIZED_COST
     * + BLENDED_COST
     * + NET_AMORTIZED_COST
     * + NET_UNBLENDED_COST
     * + UNBLENDED_COST
     */
    public val metric: aws.sdk.kotlin.services.costexplorer.model.Metric? = builder.metric
    /**
     * Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.
     */
    public val predictionIntervalLevel: kotlin.Int? = builder.predictionIntervalLevel
    /**
     * The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetCostForecastRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCostForecastRequest(")
        append("filter=$filter,")
        append("granularity=$granularity,")
        append("metric=$metric,")
        append("predictionIntervalLevel=$predictionIntervalLevel,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (granularity?.hashCode() ?: 0)
        result = 31 * result + (metric?.hashCode() ?: 0)
        result = 31 * result + (predictionIntervalLevel ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCostForecastRequest

        if (filter != other.filter) return false
        if (granularity != other.granularity) return false
        if (metric != other.metric) return false
        if (predictionIntervalLevel != other.predictionIntervalLevel) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetCostForecastRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters that you want to use to filter your forecast. The `GetCostForecast` API supports filtering by the following dimensions:
         * + `AZ`
         * + `INSTANCE_TYPE`
         * + `LINKED_ACCOUNT`
         * + `LINKED_ACCOUNT_NAME`
         * + `OPERATION`
         * + `PURCHASE_TYPE`
         * + `REGION`
         * + `SERVICE`
         * + `USAGE_TYPE`
         * + `USAGE_TYPE_GROUP`
         * + `RECORD_TYPE`
         * + `OPERATING_SYSTEM`
         * + `TENANCY`
         * + `SCOPE`
         * + `PLATFORM`
         * + `SUBSCRIPTION_ID`
         * + `LEGAL_ENTITY_NAME`
         * + `DEPLOYMENT_OPTION`
         * + `DATABASE_ENGINE`
         * + `INSTANCE_TYPE_FAMILY`
         * + `BILLING_ENTITY`
         * + `RESERVATION_ID`
         * + `SAVINGS_PLAN_ARN`
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * How granular you want the forecast to be. You can get 3 months of `DAILY` forecasts or 12 months of `MONTHLY` forecasts.
         *
         * The `GetCostForecast` operation supports only `DAILY` and `MONTHLY` granularities.
         */
        public var granularity: aws.sdk.kotlin.services.costexplorer.model.Granularity? = null
        /**
         * Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see [Why does the "blended" annotation appear on some line items in my bill?](http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
         *
         * Valid values for a `GetCostForecast` call are the following:
         * + AMORTIZED_COST
         * + BLENDED_COST
         * + NET_AMORTIZED_COST
         * + NET_UNBLENDED_COST
         * + UNBLENDED_COST
         */
        public var metric: aws.sdk.kotlin.services.costexplorer.model.Metric? = null
        /**
         * Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.
         */
        public var predictionIntervalLevel: kotlin.Int? = null
        /**
         * The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetCostForecastRequest) : this() {
            this.filter = x.filter
            this.granularity = x.granularity
            this.metric = x.metric
            this.predictionIntervalLevel = x.predictionIntervalLevel
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetCostForecastRequest = GetCostForecastRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
