// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



public class GetCostCategoriesRequest private constructor(builder: Builder) {
    /**
     * The unique name of the Cost Category.
     */
    public val costCategoryName: kotlin.String? = builder.costCategoryName
    /**
     * Use `Expression` to filter by cost or by usage. There are two patterns:
     * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
     * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
     *
     * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
     *
     * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
     */
    public val filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.filter
    /**
     * This field is only used when the `SortBy` value is provided in the request.
     *
     * The maximum number of objects that are returned for this request. If `MaxResults` isn't specified with the `SortBy` value, the request returns 1000 results as the default value for this parameter.
     *
     * For `GetCostCategories`, MaxResults has an upper quota of 1000.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * If the number of objects that are still available for retrieval exceeds the quota, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the previous call in your next request.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * The value that you want to search the filter values for.
     *
     * If you don't specify a `CostCategoryName`, `SearchString` is used to filter Cost Category names that match the `SearchString` pattern. If you specify a `CostCategoryName`, `SearchString` is used to filter Cost Category values that match the `SearchString` pattern.
     */
    public val searchString: kotlin.String? = builder.searchString
    /**
     * The value that you sort the data by.
     *
     * The key represents the cost and usage metrics. The following values are supported:
     * + `BlendedCost`
     * + `UnblendedCost`
     * + `AmortizedCost`
     * + `NetAmortizedCost`
     * + `NetUnblendedCost`
     * + `UsageQuantity`
     * + `NormalizedUsageAmount`
     *
     * The supported key values for the `SortOrder` value are `ASCENDING` and `DESCENDING`.
     *
     * When you use the `SortBy` value, the `NextPageToken` and `SearchString` key values aren't supported.
     */
    public val sortBy: List<SortDefinition>? = builder.sortBy
    /**
     * The time period of the request.
     */
    public val timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = builder.timePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.GetCostCategoriesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCostCategoriesRequest(")
        append("costCategoryName=$costCategoryName,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextPageToken=$nextPageToken,")
        append("searchString=$searchString,")
        append("sortBy=$sortBy,")
        append("timePeriod=$timePeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = costCategoryName?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (searchString?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (timePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCostCategoriesRequest

        if (costCategoryName != other.costCategoryName) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextPageToken != other.nextPageToken) return false
        if (searchString != other.searchString) return false
        if (sortBy != other.sortBy) return false
        if (timePeriod != other.timePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.GetCostCategoriesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique name of the Cost Category.
         */
        public var costCategoryName: kotlin.String? = null
        /**
         * Use `Expression` to filter by cost or by usage. There are two patterns:
         * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
         * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
         *
         * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
         *
         * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
         */
        public var filter: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * This field is only used when the `SortBy` value is provided in the request.
         *
         * The maximum number of objects that are returned for this request. If `MaxResults` isn't specified with the `SortBy` value, the request returns 1000 results as the default value for this parameter.
         *
         * For `GetCostCategories`, MaxResults has an upper quota of 1000.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * If the number of objects that are still available for retrieval exceeds the quota, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the previous call in your next request.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * The value that you want to search the filter values for.
         *
         * If you don't specify a `CostCategoryName`, `SearchString` is used to filter Cost Category names that match the `SearchString` pattern. If you specify a `CostCategoryName`, `SearchString` is used to filter Cost Category values that match the `SearchString` pattern.
         */
        public var searchString: kotlin.String? = null
        /**
         * The value that you sort the data by.
         *
         * The key represents the cost and usage metrics. The following values are supported:
         * + `BlendedCost`
         * + `UnblendedCost`
         * + `AmortizedCost`
         * + `NetAmortizedCost`
         * + `NetUnblendedCost`
         * + `UsageQuantity`
         * + `NormalizedUsageAmount`
         *
         * The supported key values for the `SortOrder` value are `ASCENDING` and `DESCENDING`.
         *
         * When you use the `SortBy` value, the `NextPageToken` and `SearchString` key values aren't supported.
         */
        public var sortBy: List<SortDefinition>? = null
        /**
         * The time period of the request.
         */
        public var timePeriod: aws.sdk.kotlin.services.costexplorer.model.DateInterval? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.GetCostCategoriesRequest) : this() {
            this.costCategoryName = x.costCategoryName
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextPageToken = x.nextPageToken
            this.searchString = x.searchString
            this.sortBy = x.sortBy
            this.timePeriod = x.timePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.GetCostCategoriesRequest = GetCostCategoriesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DateInterval] inside the given [block]
         */
        public fun timePeriod(block: aws.sdk.kotlin.services.costexplorer.model.DateInterval.Builder.() -> kotlin.Unit) {
            this.timePeriod = aws.sdk.kotlin.services.costexplorer.model.DateInterval.invoke(block)
        }
    }
}
