// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Use `Expression` to filter by cost or by usage. There are two patterns:
 * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
 * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
 *
 * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
 *
 * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
 */
public class Expression private constructor(builder: Builder) {
    /**
     * Return results that match both `Dimension` objects.
     */
    public val and: List<Expression>? = builder.and
    /**
     * The filter that's based on `CostCategory` values.
     */
    public val costCategories: aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues? = builder.costCategories
    /**
     * The specific `Dimension` to use for `Expression`.
     */
    public val dimensions: aws.sdk.kotlin.services.costexplorer.model.DimensionValues? = builder.dimensions
    /**
     * Return results that don't match a `Dimension` object.
     */
    public val not: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.not
    /**
     * Return results that match either `Dimension` object.
     */
    public val or: List<Expression>? = builder.or
    /**
     * The specific `Tag` to use for `Expression`.
     */
    public val tags: aws.sdk.kotlin.services.costexplorer.model.TagValues? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.Expression = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Expression(")
        append("and=$and,")
        append("costCategories=$costCategories,")
        append("dimensions=$dimensions,")
        append("not=$not,")
        append("or=$or,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = and?.hashCode() ?: 0
        result = 31 * result + (costCategories?.hashCode() ?: 0)
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (not?.hashCode() ?: 0)
        result = 31 * result + (or?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Expression

        if (and != other.and) return false
        if (costCategories != other.costCategories) return false
        if (dimensions != other.dimensions) return false
        if (not != other.not) return false
        if (or != other.or) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.Expression = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Return results that match both `Dimension` objects.
         */
        public var and: List<Expression>? = null
        /**
         * The filter that's based on `CostCategory` values.
         */
        public var costCategories: aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues? = null
        /**
         * The specific `Dimension` to use for `Expression`.
         */
        public var dimensions: aws.sdk.kotlin.services.costexplorer.model.DimensionValues? = null
        /**
         * Return results that don't match a `Dimension` object.
         */
        public var not: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * Return results that match either `Dimension` object.
         */
        public var or: List<Expression>? = null
        /**
         * The specific `Tag` to use for `Expression`.
         */
        public var tags: aws.sdk.kotlin.services.costexplorer.model.TagValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.Expression) : this() {
            this.and = x.and
            this.costCategories = x.costCategories
            this.dimensions = x.dimensions
            this.not = x.not
            this.or = x.or
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.Expression = Expression(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues] inside the given [block]
         */
        public fun costCategories(block: aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues.Builder.() -> kotlin.Unit) {
            this.costCategories = aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.DimensionValues] inside the given [block]
         */
        public fun dimensions(block: aws.sdk.kotlin.services.costexplorer.model.DimensionValues.Builder.() -> kotlin.Unit) {
            this.dimensions = aws.sdk.kotlin.services.costexplorer.model.DimensionValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun not(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.not = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.TagValues] inside the given [block]
         */
        public fun tags(block: aws.sdk.kotlin.services.costexplorer.model.TagValues.Builder.() -> kotlin.Unit) {
            this.tags = aws.sdk.kotlin.services.costexplorer.model.TagValues.invoke(block)
        }
    }
}
