// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Details about the Amazon OpenSearch Service instances that Amazon Web Services recommends that you purchase.
 */
public class EsInstanceDetails private constructor(builder: Builder) {
    /**
     * Determines whether the recommendation is for a current-generation instance.
     */
    public val currentGeneration: kotlin.Boolean = builder.currentGeneration
    /**
     * The class of instance that Amazon Web Services recommends.
     */
    public val instanceClass: kotlin.String? = builder.instanceClass
    /**
     * The size of instance that Amazon Web Services recommends.
     */
    public val instanceSize: kotlin.String? = builder.instanceSize
    /**
     * The Amazon Web Services Region of the recommended reservation.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Determines whether the recommended reservation is size flexible.
     */
    public val sizeFlexEligible: kotlin.Boolean = builder.sizeFlexEligible

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.EsInstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EsInstanceDetails(")
        append("currentGeneration=$currentGeneration,")
        append("instanceClass=$instanceClass,")
        append("instanceSize=$instanceSize,")
        append("region=$region,")
        append("sizeFlexEligible=$sizeFlexEligible)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentGeneration.hashCode()
        result = 31 * result + (instanceClass?.hashCode() ?: 0)
        result = 31 * result + (instanceSize?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (sizeFlexEligible.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EsInstanceDetails

        if (currentGeneration != other.currentGeneration) return false
        if (instanceClass != other.instanceClass) return false
        if (instanceSize != other.instanceSize) return false
        if (region != other.region) return false
        if (sizeFlexEligible != other.sizeFlexEligible) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.EsInstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether the recommendation is for a current-generation instance.
         */
        public var currentGeneration: kotlin.Boolean = false
        /**
         * The class of instance that Amazon Web Services recommends.
         */
        public var instanceClass: kotlin.String? = null
        /**
         * The size of instance that Amazon Web Services recommends.
         */
        public var instanceSize: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the recommended reservation.
         */
        public var region: kotlin.String? = null
        /**
         * Determines whether the recommended reservation is size flexible.
         */
        public var sizeFlexEligible: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.EsInstanceDetails) : this() {
            this.currentGeneration = x.currentGeneration
            this.instanceClass = x.instanceClass
            this.instanceSize = x.instanceSize
            this.region = x.region
            this.sizeFlexEligible = x.sizeFlexEligible
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.EsInstanceDetails = EsInstanceDetails(this)
    }
}
