// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * The amount of instance usage, in normalized units. You can use normalized units to see your EC2 usage for multiple sizes of instances in a uniform way. For example, suppose that you run an xlarge instance and a 2xlarge instance. If you run both instances for the same amount of time, the 2xlarge instance uses twice as much of your reservation as the xlarge instance, even though both instances show only one instance-hour. When you use normalized units instead of instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge instance used 16 normalized units.
 *
 * For more information, see [Modifying Reserved Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*.
 */
public class CoverageNormalizedUnits private constructor(builder: Builder) {
    /**
     * The percentage of your used instance normalized units that a reservation covers.
     */
    public val coverageNormalizedUnitsPercentage: kotlin.String? = builder.coverageNormalizedUnitsPercentage
    /**
     * The number of normalized units that are covered by On-Demand Instances instead of a reservation.
     */
    public val onDemandNormalizedUnits: kotlin.String? = builder.onDemandNormalizedUnits
    /**
     * The number of normalized units that a reservation covers.
     */
    public val reservedNormalizedUnits: kotlin.String? = builder.reservedNormalizedUnits
    /**
     * The total number of normalized units that you used.
     */
    public val totalRunningNormalizedUnits: kotlin.String? = builder.totalRunningNormalizedUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.CoverageNormalizedUnits = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoverageNormalizedUnits(")
        append("coverageNormalizedUnitsPercentage=$coverageNormalizedUnitsPercentage,")
        append("onDemandNormalizedUnits=$onDemandNormalizedUnits,")
        append("reservedNormalizedUnits=$reservedNormalizedUnits,")
        append("totalRunningNormalizedUnits=$totalRunningNormalizedUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coverageNormalizedUnitsPercentage?.hashCode() ?: 0
        result = 31 * result + (onDemandNormalizedUnits?.hashCode() ?: 0)
        result = 31 * result + (reservedNormalizedUnits?.hashCode() ?: 0)
        result = 31 * result + (totalRunningNormalizedUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoverageNormalizedUnits

        if (coverageNormalizedUnitsPercentage != other.coverageNormalizedUnitsPercentage) return false
        if (onDemandNormalizedUnits != other.onDemandNormalizedUnits) return false
        if (reservedNormalizedUnits != other.reservedNormalizedUnits) return false
        if (totalRunningNormalizedUnits != other.totalRunningNormalizedUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.CoverageNormalizedUnits = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The percentage of your used instance normalized units that a reservation covers.
         */
        public var coverageNormalizedUnitsPercentage: kotlin.String? = null
        /**
         * The number of normalized units that are covered by On-Demand Instances instead of a reservation.
         */
        public var onDemandNormalizedUnits: kotlin.String? = null
        /**
         * The number of normalized units that a reservation covers.
         */
        public var reservedNormalizedUnits: kotlin.String? = null
        /**
         * The total number of normalized units that you used.
         */
        public var totalRunningNormalizedUnits: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.CoverageNormalizedUnits) : this() {
            this.coverageNormalizedUnitsPercentage = x.coverageNormalizedUnitsPercentage
            this.onDemandNormalizedUnits = x.onDemandNormalizedUnits
            this.reservedNormalizedUnits = x.reservedNormalizedUnits
            this.totalRunningNormalizedUnits = x.totalRunningNormalizedUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.CoverageNormalizedUnits = CoverageNormalizedUnits(this)
    }
}
