// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * The Cost Categories values used for filtering the costs.
 *
 * If `Values` and `Key` are not specified, the `ABSENT``MatchOption` is applied to all Cost Categories. That is, it filters on resources that aren't mapped to any Cost Categories.
 *
 * If `Values` is provided and `Key` isn't specified, the `ABSENT``MatchOption` is applied to the Cost Categories `Key` only. That is, it filters on resources without the given Cost Categories key.
 */
public class CostCategoryValues private constructor(builder: Builder) {
    /**
     * The unique name of the Cost Category.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for `MatchOptions` is `EQUALS` and `CASE_SENSITIVE`.
     */
    public val matchOptions: List<MatchOption>? = builder.matchOptions
    /**
     * The specific value of the Cost Category.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostCategoryValues(")
        append("key=$key,")
        append("matchOptions=$matchOptions,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (matchOptions?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostCategoryValues

        if (key != other.key) return false
        if (matchOptions != other.matchOptions) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique name of the Cost Category.
         */
        public var key: kotlin.String? = null
        /**
         * The match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for `MatchOptions` is `EQUALS` and `CASE_SENSITIVE`.
         */
        public var matchOptions: List<MatchOption>? = null
        /**
         * The specific value of the Cost Category.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues) : this() {
            this.key = x.key
            this.matchOptions = x.matchOptions
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.CostCategoryValues = CostCategoryValues(this)
    }
}
