// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Use the split charge rule to split the cost of one Cost Category value across several other target values.
 */
public class CostCategorySplitChargeRule private constructor(builder: Builder) {
    /**
     * The method that's used to define how to split your source costs across your targets.
     *
     * `Proportional` - Allocates charges across your targets based on the proportional weighted cost of each target.
     *
     * `Fixed` - Allocates charges across your targets based on your defined allocation percentage.
     *
     * >`Even` - Allocates costs evenly across all targets.
     */
    public val method: aws.sdk.kotlin.services.costexplorer.model.CostCategorySplitChargeMethod? = builder.method
    /**
     * The parameters for a split charge method. This is only required for the `FIXED` method.
     */
    public val parameters: List<CostCategorySplitChargeRuleParameter>? = builder.parameters
    /**
     * The Cost Category value that you want to split. That value can't be used as a source or a target in other split charge rules. To indicate uncategorized costs, you can use an empty string as the source.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
     */
    public val targets: List<String>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.CostCategorySplitChargeRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostCategorySplitChargeRule(")
        append("method=$method,")
        append("parameters=$parameters,")
        append("source=$source,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = method?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostCategorySplitChargeRule

        if (method != other.method) return false
        if (parameters != other.parameters) return false
        if (source != other.source) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.CostCategorySplitChargeRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The method that's used to define how to split your source costs across your targets.
         *
         * `Proportional` - Allocates charges across your targets based on the proportional weighted cost of each target.
         *
         * `Fixed` - Allocates charges across your targets based on your defined allocation percentage.
         *
         * >`Even` - Allocates costs evenly across all targets.
         */
        public var method: aws.sdk.kotlin.services.costexplorer.model.CostCategorySplitChargeMethod? = null
        /**
         * The parameters for a split charge method. This is only required for the `FIXED` method.
         */
        public var parameters: List<CostCategorySplitChargeRuleParameter>? = null
        /**
         * The Cost Category value that you want to split. That value can't be used as a source or a target in other split charge rules. To indicate uncategorized costs, you can use an empty string as the source.
         */
        public var source: kotlin.String? = null
        /**
         * The Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
         */
        public var targets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.CostCategorySplitChargeRule) : this() {
            this.method = x.method
            this.parameters = x.parameters
            this.source = x.source
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.CostCategorySplitChargeRule = CostCategorySplitChargeRule(this)
    }
}
