// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value.
 */
public class CostCategoryRule private constructor(builder: Builder) {
    /**
     * The value the line item is categorized as if the line item contains the matched dimension.
     */
    public val inheritedValue: aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension? = builder.inheritedValue
    /**
     * An [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only dimensions supported are `LINKED_ACCOUNT`, `SERVICE_CODE`, `RECORD_TYPE`, and `LINKED_ACCOUNT_NAME`.
     *
     * Root level `OR` isn't supported. We recommend that you create a separate rule instead.
     *
     * `RECORD_TYPE` is a dimension used for Cost Explorer APIs, and is also supported for Cost Category expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON editor. For a detailed comparison, see [Term Comparisons](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms) in the *Billing and Cost Management User Guide*.
     */
    public val rule: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.rule
    /**
     * You can define the `CostCategoryRule` rule type as either `REGULAR` or `INHERITED_VALUE`. The `INHERITED_VALUE` rule type adds the flexibility to define a rule that dynamically inherits the cost category value. This value is from the dimension value that's defined by `CostCategoryInheritedValueDimension`. For example, suppose that you want to costs to be dynamically grouped based on the value of a specific tag key. First, choose an inherited value rule type, and then choose the tag dimension and specify the tag key to use.
     */
    public val type: aws.sdk.kotlin.services.costexplorer.model.CostCategoryRuleType? = builder.type
    /**
     * The default value for the cost category.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.CostCategoryRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostCategoryRule(")
        append("inheritedValue=$inheritedValue,")
        append("rule=$rule,")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = inheritedValue?.hashCode() ?: 0
        result = 31 * result + (rule?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostCategoryRule

        if (inheritedValue != other.inheritedValue) return false
        if (rule != other.rule) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.CostCategoryRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The value the line item is categorized as if the line item contains the matched dimension.
         */
        public var inheritedValue: aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension? = null
        /**
         * An [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only dimensions supported are `LINKED_ACCOUNT`, `SERVICE_CODE`, `RECORD_TYPE`, and `LINKED_ACCOUNT_NAME`.
         *
         * Root level `OR` isn't supported. We recommend that you create a separate rule instead.
         *
         * `RECORD_TYPE` is a dimension used for Cost Explorer APIs, and is also supported for Cost Category expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON editor. For a detailed comparison, see [Term Comparisons](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms) in the *Billing and Cost Management User Guide*.
         */
        public var rule: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * You can define the `CostCategoryRule` rule type as either `REGULAR` or `INHERITED_VALUE`. The `INHERITED_VALUE` rule type adds the flexibility to define a rule that dynamically inherits the cost category value. This value is from the dimension value that's defined by `CostCategoryInheritedValueDimension`. For example, suppose that you want to costs to be dynamically grouped based on the value of a specific tag key. First, choose an inherited value rule type, and then choose the tag dimension and specify the tag key to use.
         */
        public var type: aws.sdk.kotlin.services.costexplorer.model.CostCategoryRuleType? = null
        /**
         * The default value for the cost category.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.CostCategoryRule) : this() {
            this.inheritedValue = x.inheritedValue
            this.rule = x.rule
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.CostCategoryRule = CostCategoryRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension] inside the given [block]
         */
        public fun inheritedValue(block: aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension.Builder.() -> kotlin.Unit) {
            this.inheritedValue = aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun rule(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.rule = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }
    }
}
