// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * A reference to a Cost Category containing only enough information to identify the Cost Category.
 *
 * You can use this information to retrieve the full Cost Category information using `DescribeCostCategory`.
 */
public class CostCategoryReference private constructor(builder: Builder) {
    /**
     * The unique identifier for your Cost Category.
     */
    public val costCategoryArn: kotlin.String? = builder.costCategoryArn
    /**
     * The default value for the cost category.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * The Cost Category's effective end date.
     */
    public val effectiveEnd: kotlin.String? = builder.effectiveEnd
    /**
     * The Cost Category's effective start date.
     */
    public val effectiveStart: kotlin.String? = builder.effectiveStart
    /**
     * The unique name of the Cost Category.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The number of rules that are associated with a specific Cost Category.
     */
    public val numberOfRules: kotlin.Int = builder.numberOfRules
    /**
     * The list of processing statuses for Cost Management products for a specific cost category.
     */
    public val processingStatus: List<CostCategoryProcessingStatus>? = builder.processingStatus
    /**
     * A list of unique cost category values in a specific cost category.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.CostCategoryReference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostCategoryReference(")
        append("costCategoryArn=$costCategoryArn,")
        append("defaultValue=$defaultValue,")
        append("effectiveEnd=$effectiveEnd,")
        append("effectiveStart=$effectiveStart,")
        append("name=$name,")
        append("numberOfRules=$numberOfRules,")
        append("processingStatus=$processingStatus,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = costCategoryArn?.hashCode() ?: 0
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (effectiveEnd?.hashCode() ?: 0)
        result = 31 * result + (effectiveStart?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberOfRules)
        result = 31 * result + (processingStatus?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostCategoryReference

        if (costCategoryArn != other.costCategoryArn) return false
        if (defaultValue != other.defaultValue) return false
        if (effectiveEnd != other.effectiveEnd) return false
        if (effectiveStart != other.effectiveStart) return false
        if (name != other.name) return false
        if (numberOfRules != other.numberOfRules) return false
        if (processingStatus != other.processingStatus) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.CostCategoryReference = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for your Cost Category.
         */
        public var costCategoryArn: kotlin.String? = null
        /**
         * The default value for the cost category.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * The Cost Category's effective end date.
         */
        public var effectiveEnd: kotlin.String? = null
        /**
         * The Cost Category's effective start date.
         */
        public var effectiveStart: kotlin.String? = null
        /**
         * The unique name of the Cost Category.
         */
        public var name: kotlin.String? = null
        /**
         * The number of rules that are associated with a specific Cost Category.
         */
        public var numberOfRules: kotlin.Int = 0
        /**
         * The list of processing statuses for Cost Management products for a specific cost category.
         */
        public var processingStatus: List<CostCategoryProcessingStatus>? = null
        /**
         * A list of unique cost category values in a specific cost category.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.CostCategoryReference) : this() {
            this.costCategoryArn = x.costCategoryArn
            this.defaultValue = x.defaultValue
            this.effectiveEnd = x.effectiveEnd
            this.effectiveStart = x.effectiveStart
            this.name = x.name
            this.numberOfRules = x.numberOfRules
            this.processingStatus = x.processingStatus
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.CostCategoryReference = CostCategoryReference(this)
    }
}
