// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * When you create or update a cost category, you can define the `CostCategoryRule` rule type as `INHERITED_VALUE`. This rule type adds the flexibility to define a rule that dynamically inherits the cost category value from the dimension value that's defined by `CostCategoryInheritedValueDimension`. For example, suppose that you want to dynamically group costs that are based on the value of a specific tag key. First, choose an inherited value rule type, and then choose the tag dimension and specify the tag key to use.
 */
public class CostCategoryInheritedValueDimension private constructor(builder: Builder) {
    /**
     * The key to extract cost category values.
     */
    public val dimensionKey: kotlin.String? = builder.dimensionKey
    /**
     * The name of the dimension that's used to group costs.
     *
     * If you specify `LINKED_ACCOUNT_NAME`, the cost category value is based on account name. If you specify `TAG`, the cost category value is based on the value of the specified tag key.
     */
    public val dimensionName: aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimensionName? = builder.dimensionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostCategoryInheritedValueDimension(")
        append("dimensionKey=$dimensionKey,")
        append("dimensionName=$dimensionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensionKey?.hashCode() ?: 0
        result = 31 * result + (dimensionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostCategoryInheritedValueDimension

        if (dimensionKey != other.dimensionKey) return false
        if (dimensionName != other.dimensionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The key to extract cost category values.
         */
        public var dimensionKey: kotlin.String? = null
        /**
         * The name of the dimension that's used to group costs.
         *
         * If you specify `LINKED_ACCOUNT_NAME`, the cost category value is based on account name. If you specify `TAG`, the cost category value is based on the value of the specified tag key.
         */
        public var dimensionName: aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimensionName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension) : this() {
            this.dimensionKey = x.dimensionKey
            this.dimensionName = x.dimensionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.CostCategoryInheritedValueDimension = CostCategoryInheritedValueDimension(this)
    }
}
