// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * The association between a monitor, threshold, and list of subscribers used to deliver notifications about anomalies detected by a monitor that exceeds a threshold. The content consists of the detailed metadata and the current status of the `AnomalySubscription` object.
 */
public class AnomalySubscription private constructor(builder: Builder) {
    /**
     * Your unique account identifier.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The frequency that anomaly reports are sent over email.
     */
    public val frequency: aws.sdk.kotlin.services.costexplorer.model.AnomalySubscriptionFrequency? = builder.frequency
    /**
     * A list of cost anomaly monitors.
     */
    public val monitorArnList: List<String>? = builder.monitorArnList
    /**
     * A list of subscribers to notify.
     */
    public val subscribers: List<Subscriber>? = builder.subscribers
    /**
     * The `AnomalySubscription` Amazon Resource Name (ARN).
     */
    public val subscriptionArn: kotlin.String? = builder.subscriptionArn
    /**
     * The name for the subscription.
     */
    public val subscriptionName: kotlin.String? = builder.subscriptionName
    /**
     * The dollar value that triggers a notification if the threshold is exceeded.
     */
    public val threshold: kotlin.Double? = builder.threshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.AnomalySubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnomalySubscription(")
        append("accountId=$accountId,")
        append("frequency=$frequency,")
        append("monitorArnList=$monitorArnList,")
        append("subscribers=$subscribers,")
        append("subscriptionArn=$subscriptionArn,")
        append("subscriptionName=$subscriptionName,")
        append("threshold=$threshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (frequency?.hashCode() ?: 0)
        result = 31 * result + (monitorArnList?.hashCode() ?: 0)
        result = 31 * result + (subscribers?.hashCode() ?: 0)
        result = 31 * result + (subscriptionArn?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnomalySubscription

        if (accountId != other.accountId) return false
        if (frequency != other.frequency) return false
        if (monitorArnList != other.monitorArnList) return false
        if (subscribers != other.subscribers) return false
        if (subscriptionArn != other.subscriptionArn) return false
        if (subscriptionName != other.subscriptionName) return false
        if (threshold != other.threshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.AnomalySubscription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Your unique account identifier.
         */
        public var accountId: kotlin.String? = null
        /**
         * The frequency that anomaly reports are sent over email.
         */
        public var frequency: aws.sdk.kotlin.services.costexplorer.model.AnomalySubscriptionFrequency? = null
        /**
         * A list of cost anomaly monitors.
         */
        public var monitorArnList: List<String>? = null
        /**
         * A list of subscribers to notify.
         */
        public var subscribers: List<Subscriber>? = null
        /**
         * The `AnomalySubscription` Amazon Resource Name (ARN).
         */
        public var subscriptionArn: kotlin.String? = null
        /**
         * The name for the subscription.
         */
        public var subscriptionName: kotlin.String? = null
        /**
         * The dollar value that triggers a notification if the threshold is exceeded.
         */
        public var threshold: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.AnomalySubscription) : this() {
            this.accountId = x.accountId
            this.frequency = x.frequency
            this.monitorArnList = x.monitorArnList
            this.subscribers = x.subscribers
            this.subscriptionArn = x.subscriptionArn
            this.subscriptionName = x.subscriptionName
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.AnomalySubscription = AnomalySubscription(this)
    }
}
