// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer.model



/**
 * This object continuously inspects your account's cost data for anomalies. It's based on `MonitorType` and `MonitorSpecification`. The content consists of detailed metadata and the current status of the monitor object.
 */
public class AnomalyMonitor private constructor(builder: Builder) {
    /**
     * The date when the monitor was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The value for evaluated dimensions.
     */
    public val dimensionalValueCount: kotlin.Int = builder.dimensionalValueCount
    /**
     * The date when the monitor last evaluated for anomalies.
     */
    public val lastEvaluatedDate: kotlin.String? = builder.lastEvaluatedDate
    /**
     * The date when the monitor was last updated.
     */
    public val lastUpdatedDate: kotlin.String? = builder.lastUpdatedDate
    /**
     * The Amazon Resource Name (ARN) value.
     */
    public val monitorArn: kotlin.String? = builder.monitorArn
    /**
     * The dimensions to evaluate.
     */
    public val monitorDimension: aws.sdk.kotlin.services.costexplorer.model.MonitorDimension? = builder.monitorDimension
    /**
     * The name of the monitor.
     */
    public val monitorName: kotlin.String? = builder.monitorName
    /**
     * Use `Expression` to filter by cost or by usage. There are two patterns:
     * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
     * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
     *
     * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
     *
     * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
     */
    public val monitorSpecification: aws.sdk.kotlin.services.costexplorer.model.Expression? = builder.monitorSpecification
    /**
     * The possible type values.
     */
    public val monitorType: aws.sdk.kotlin.services.costexplorer.model.MonitorType? = builder.monitorType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costexplorer.model.AnomalyMonitor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnomalyMonitor(")
        append("creationDate=$creationDate,")
        append("dimensionalValueCount=$dimensionalValueCount,")
        append("lastEvaluatedDate=$lastEvaluatedDate,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("monitorArn=$monitorArn,")
        append("monitorDimension=$monitorDimension,")
        append("monitorName=$monitorName,")
        append("monitorSpecification=$monitorSpecification,")
        append("monitorType=$monitorType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (dimensionalValueCount)
        result = 31 * result + (lastEvaluatedDate?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (monitorArn?.hashCode() ?: 0)
        result = 31 * result + (monitorDimension?.hashCode() ?: 0)
        result = 31 * result + (monitorName?.hashCode() ?: 0)
        result = 31 * result + (monitorSpecification?.hashCode() ?: 0)
        result = 31 * result + (monitorType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnomalyMonitor

        if (creationDate != other.creationDate) return false
        if (dimensionalValueCount != other.dimensionalValueCount) return false
        if (lastEvaluatedDate != other.lastEvaluatedDate) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (monitorArn != other.monitorArn) return false
        if (monitorDimension != other.monitorDimension) return false
        if (monitorName != other.monitorName) return false
        if (monitorSpecification != other.monitorSpecification) return false
        if (monitorType != other.monitorType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costexplorer.model.AnomalyMonitor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date when the monitor was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The value for evaluated dimensions.
         */
        public var dimensionalValueCount: kotlin.Int = 0
        /**
         * The date when the monitor last evaluated for anomalies.
         */
        public var lastEvaluatedDate: kotlin.String? = null
        /**
         * The date when the monitor was last updated.
         */
        public var lastUpdatedDate: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) value.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * The dimensions to evaluate.
         */
        public var monitorDimension: aws.sdk.kotlin.services.costexplorer.model.MonitorDimension? = null
        /**
         * The name of the monitor.
         */
        public var monitorName: kotlin.String? = null
        /**
         * Use `Expression` to filter by cost or by usage. There are two patterns:
         * + Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for `REGION==us-east-1 OR REGION==us-west-1`. For `GetRightsizingRecommendation`, the Region is a full name (for example, `REGION==US East (N. Virginia)`. The `Expression` example is as follows:`{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }`The list of dimension values are OR'd together to retrieve cost or usage data. You can create `Expression` and `DimensionValues` objects using either `with*` methods or `set*` methods in multiple lines.
         * + Compound dimension values with logical operations - You can use multiple `Expression` types and the logical operators `AND/OR/NOT` to create a list of one or more `Expression` objects. By doing this, you can filter on more advanced options. For example, you can filter on `((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)`. The `Expression` for that is as follows:`{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } `Because each `Expression` can have only one operator, the service returns an error if more than one is specified. The following example shows an `Expression` object that creates an error.` { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } `
         *
         * For the `GetRightsizingRecommendation` action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to `LINKED_ACCOUNT`, `REGION`, or `RIGHTSIZING_TYPE`.
         *
         * For the `GetReservationPurchaseRecommendation` action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to `LINKED_ACCOUNT`.
         */
        public var monitorSpecification: aws.sdk.kotlin.services.costexplorer.model.Expression? = null
        /**
         * The possible type values.
         */
        public var monitorType: aws.sdk.kotlin.services.costexplorer.model.MonitorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costexplorer.model.AnomalyMonitor) : this() {
            this.creationDate = x.creationDate
            this.dimensionalValueCount = x.dimensionalValueCount
            this.lastEvaluatedDate = x.lastEvaluatedDate
            this.lastUpdatedDate = x.lastUpdatedDate
            this.monitorArn = x.monitorArn
            this.monitorDimension = x.monitorDimension
            this.monitorName = x.monitorName
            this.monitorSpecification = x.monitorSpecification
            this.monitorType = x.monitorType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costexplorer.model.AnomalyMonitor = AnomalyMonitor(this)

        /**
         * construct an [aws.sdk.kotlin.services.costexplorer.model.Expression] inside the given [block]
         */
        public fun monitorSpecification(block: aws.sdk.kotlin.services.costexplorer.model.Expression.Builder.() -> kotlin.Unit) {
            this.monitorSpecification = aws.sdk.kotlin.services.costexplorer.model.Expression.invoke(block)
        }
    }
}
