// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.costexplorer.model.*
import aws.sdk.kotlin.services.costexplorer.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Cost Explorer"
public const val ServiceApiVersion: String = "2017-10-25"
public const val SdkVersion: String = "0.17.12-beta"

internal class DefaultCostExplorerClient(override val config: CostExplorerClient.Config) : CostExplorerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
     */
    override suspend fun createAnomalyMonitor(input: CreateAnomalyMonitorRequest): CreateAnomalyMonitorResponse {
        val op = SdkHttpOperation.build<CreateAnomalyMonitorRequest, CreateAnomalyMonitorResponse> {
            serializer = CreateAnomalyMonitorOperationSerializer()
            deserializer = CreateAnomalyMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAnomalyMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving notifications.
     */
    override suspend fun createAnomalySubscription(input: CreateAnomalySubscriptionRequest): CreateAnomalySubscriptionResponse {
        val op = SdkHttpOperation.build<CreateAnomalySubscriptionRequest, CreateAnomalySubscriptionResponse> {
            serializer = CreateAnomalySubscriptionOperationSerializer()
            deserializer = CreateAnomalySubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAnomalySubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Cost Category with the requested name and rules.
     */
    override suspend fun createCostCategoryDefinition(input: CreateCostCategoryDefinitionRequest): CreateCostCategoryDefinitionResponse {
        val op = SdkHttpOperation.build<CreateCostCategoryDefinitionRequest, CreateCostCategoryDefinitionResponse> {
            serializer = CreateCostCategoryDefinitionOperationSerializer()
            deserializer = CreateCostCategoryDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCostCategoryDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a cost anomaly monitor.
     */
    override suspend fun deleteAnomalyMonitor(input: DeleteAnomalyMonitorRequest): DeleteAnomalyMonitorResponse {
        val op = SdkHttpOperation.build<DeleteAnomalyMonitorRequest, DeleteAnomalyMonitorResponse> {
            serializer = DeleteAnomalyMonitorOperationSerializer()
            deserializer = DeleteAnomalyMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAnomalyMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a cost anomaly subscription.
     */
    override suspend fun deleteAnomalySubscription(input: DeleteAnomalySubscriptionRequest): DeleteAnomalySubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteAnomalySubscriptionRequest, DeleteAnomalySubscriptionResponse> {
            serializer = DeleteAnomalySubscriptionOperationSerializer()
            deserializer = DeleteAnomalySubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAnomalySubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost Category.
     */
    override suspend fun deleteCostCategoryDefinition(input: DeleteCostCategoryDefinitionRequest): DeleteCostCategoryDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteCostCategoryDefinitionRequest, DeleteCostCategoryDefinitionResponse> {
            serializer = DeleteCostCategoryDefinitionOperationSerializer()
            deserializer = DeleteCostCategoryDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCostCategoryDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's defined in the account.
     *
     * You have the option to use `EffectiveOn` to return a Cost Category that's active on a specific date. If there's no `EffectiveOn` specified, you see a Cost Category that's effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response.
     */
    override suspend fun describeCostCategoryDefinition(input: DescribeCostCategoryDefinitionRequest): DescribeCostCategoryDefinitionResponse {
        val op = SdkHttpOperation.build<DescribeCostCategoryDefinitionRequest, DescribeCostCategoryDefinitionResponse> {
            serializer = DescribeCostCategoryDefinitionOperationSerializer()
            deserializer = DescribeCostCategoryDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCostCategoryDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the `DateInterval` object.
     */
    override suspend fun getAnomalies(input: GetAnomaliesRequest): GetAnomaliesResponse {
        val op = SdkHttpOperation.build<GetAnomaliesRequest, GetAnomaliesResponse> {
            serializer = GetAnomaliesOperationSerializer()
            deserializer = GetAnomaliesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAnomalies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
     */
    override suspend fun getAnomalyMonitors(input: GetAnomalyMonitorsRequest): GetAnomalyMonitorsResponse {
        val op = SdkHttpOperation.build<GetAnomalyMonitorsRequest, GetAnomalyMonitorsResponse> {
            serializer = GetAnomalyMonitorsOperationSerializer()
            deserializer = GetAnomalyMonitorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAnomalyMonitors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
     */
    override suspend fun getAnomalySubscriptions(input: GetAnomalySubscriptionsRequest): GetAnomalySubscriptionsResponse {
        val op = SdkHttpOperation.build<GetAnomalySubscriptionsRequest, GetAnomalySubscriptionsResponse> {
            serializer = GetAnomalySubscriptionsOperationSerializer()
            deserializer = GetAnomalySubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAnomalySubscriptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you want the request to return. For example, you can specify `BlendedCosts` or `UsageQuantity`. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [GetDimensionValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html) operation. Management account in an organization in Organizations have access to all member accounts.
     *
     * For information about filter limitations, see [Quotas and restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html) in the *Billing and Cost Management User Guide*.
     */
    override suspend fun getCostAndUsage(input: GetCostAndUsageRequest): GetCostAndUsageResponse {
        val op = SdkHttpOperation.build<GetCostAndUsageRequest, GetCostAndUsageResponse> {
            serializer = GetCostAndUsageOperationSerializer()
            deserializer = GetCostAndUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCostAndUsage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related metric, such as `BlendedCosts` or `UsageQuantity`, that you want the request to return. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [GetDimensionValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html) operation. Management account in an organization in Organizations have access to all member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
     *
     * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information about how to access the Settings page, see [Controlling Access for Cost Explorer](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html) in the *Billing and Cost Management User Guide*.
     */
    override suspend fun getCostAndUsageWithResources(input: GetCostAndUsageWithResourcesRequest): GetCostAndUsageWithResourcesResponse {
        val op = SdkHttpOperation.build<GetCostAndUsageWithResourcesRequest, GetCostAndUsageWithResourcesResponse> {
            serializer = GetCostAndUsageWithResourcesOperationSerializer()
            deserializer = GetCostAndUsageWithResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCostAndUsageWithResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves an array of Cost Category names and values incurred cost.
     *
     * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
     */
    override suspend fun getCostCategories(input: GetCostCategoriesRequest): GetCostCategoriesResponse {
        val op = SdkHttpOperation.build<GetCostCategoriesRequest, GetCostCategoriesResponse> {
            serializer = GetCostCategoriesOperationSerializer()
            deserializer = GetCostCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCostCategories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs.
     */
    override suspend fun getCostForecast(input: GetCostForecastRequest): GetCostForecastResponse {
        val op = SdkHttpOperation.build<GetCostForecastRequest, GetCostForecastResponse> {
            serializer = GetCostForecastOperationSerializer()
            deserializer = GetCostForecastOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCostForecast"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension values for an arbitrary string.
     */
    override suspend fun getDimensionValues(input: GetDimensionValuesRequest): GetDimensionValuesResponse {
        val op = SdkHttpOperation.build<GetDimensionValuesRequest, GetDimensionValuesResponse> {
            serializer = GetDimensionValuesOperationSerializer()
            deserializer = GetDimensionValuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDimensionValues"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a reservation. An organization's management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about reservation usage by the following dimensions:
     * + AZ
     * + CACHE_ENGINE
     * + DATABASE_ENGINE
     * + DEPLOYMENT_OPTION
     * + INSTANCE_TYPE
     * + LINKED_ACCOUNT
     * + OPERATING_SYSTEM
     * + PLATFORM
     * + REGION
     * + SERVICE
     * + TAG
     * + TENANCY
     *
     * To determine valid values for a dimension, use the `GetDimensionValues` operation.
     */
    override suspend fun getReservationCoverage(input: GetReservationCoverageRequest): GetReservationCoverageResponse {
        val op = SdkHttpOperation.build<GetReservationCoverageRequest, GetReservationCoverageResponse> {
            serializer = GetReservationCoverageOperationSerializer()
            deserializer = GetReservationCoverageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReservationCoverage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets recommendations for reservation purchases. These recommendations might help you to reduce your costs. Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
     *
     * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services has these categories, it simulates every combination of reservations in each category of usage to identify the best number of each type of Reserved Instance (RI) to purchase to maximize your estimated savings.
     *
     * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes it easier to purchase a size-flexible Reserved Instance (RI). Amazon Web Services also shows the equal number of normalized units. This way, you can purchase any instance size that you want. For this example, your RI recommendation is for `c4.large` because that is the smallest size instance in the c4 instance family.
     */
    override suspend fun getReservationPurchaseRecommendation(input: GetReservationPurchaseRecommendationRequest): GetReservationPurchaseRecommendationResponse {
        val op = SdkHttpOperation.build<GetReservationPurchaseRecommendationRequest, GetReservationPurchaseRecommendationResponse> {
            serializer = GetReservationPurchaseRecommendationOperationSerializer()
            deserializer = GetReservationPurchaseRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReservationPurchaseRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the reservation utilization for your account. Management account in an organization have access to member accounts. You can filter data by dimensions in a time period. You can use `GetDimensionValues` to determine the possible dimension values. Currently, you can group only by `SUBSCRIPTION_ID`.
     */
    override suspend fun getReservationUtilization(input: GetReservationUtilizationRequest): GetReservationUtilizationResponse {
        val op = SdkHttpOperation.build<GetReservationUtilizationRequest, GetReservationUtilizationResponse> {
            serializer = GetReservationUtilizationOperationSerializer()
            deserializer = GetReservationUtilizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReservationUtilization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
     *
     * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and metrics. For more information about calculation and function, see [Optimizing Your Cost with Rightsizing Recommendations](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html) in the *Billing and Cost Management User Guide*.
     */
    override suspend fun getRightsizingRecommendation(input: GetRightsizingRecommendationRequest): GetRightsizingRecommendationResponse {
        val op = SdkHttpOperation.build<GetRightsizingRecommendationRequest, GetRightsizingRecommendationResponse> {
            serializer = GetRightsizingRecommendationOperationSerializer()
            deserializer = GetRightsizingRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRightsizingRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for Savings Plans usage with the following dimensions:
     * + `LINKED_ACCOUNT`
     * + `REGION`
     * + `SERVICE`
     * + `INSTANCE_FAMILY`
     *
     * To determine valid values for a dimension, use the `GetDimensionValues` operation.
     */
    override suspend fun getSavingsPlansCoverage(input: GetSavingsPlansCoverageRequest): GetSavingsPlansCoverageResponse {
        val op = SdkHttpOperation.build<GetSavingsPlansCoverageRequest, GetSavingsPlansCoverageResponse> {
            serializer = GetSavingsPlansCoverageOperationSerializer()
            deserializer = GetSavingsPlansCoverageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSavingsPlansCoverage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves your request parameters, Savings Plan Recommendations Summary and Details.
     */
    override suspend fun getSavingsPlansPurchaseRecommendation(input: GetSavingsPlansPurchaseRecommendationRequest): GetSavingsPlansPurchaseRecommendationResponse {
        val op = SdkHttpOperation.build<GetSavingsPlansPurchaseRecommendationRequest, GetSavingsPlansPurchaseRecommendationResponse> {
            serializer = GetSavingsPlansPurchaseRecommendationOperationSerializer()
            deserializer = GetSavingsPlansPurchaseRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSavingsPlansPurchaseRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use `GetDimensionValues` in `SAVINGS_PLANS` to determine the possible dimension values.
     *
     * You can't group by any dimension values for `GetSavingsPlansUtilization`.
     */
    override suspend fun getSavingsPlansUtilization(input: GetSavingsPlansUtilizationRequest): GetSavingsPlansUtilizationResponse {
        val op = SdkHttpOperation.build<GetSavingsPlansUtilizationRequest, GetSavingsPlansUtilizationResponse> {
            serializer = GetSavingsPlansUtilizationOperationSerializer()
            deserializer = GetSavingsPlansUtilizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSavingsPlansUtilization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to `GetSavingsPlanUtilization`, but you have the option to make multiple calls to `GetSavingsPlanUtilizationDetails` by providing individual dates. You can use `GetDimensionValues` in `SAVINGS_PLANS` to determine the possible dimension values.
     *
     * `GetSavingsPlanUtilizationDetails` internally groups data by `SavingsPlansArn`.
     */
    override suspend fun getSavingsPlansUtilizationDetails(input: GetSavingsPlansUtilizationDetailsRequest): GetSavingsPlansUtilizationDetailsResponse {
        val op = SdkHttpOperation.build<GetSavingsPlansUtilizationDetailsRequest, GetSavingsPlansUtilizationDetailsResponse> {
            serializer = GetSavingsPlansUtilizationDetailsOperationSerializer()
            deserializer = GetSavingsPlansUtilizationDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSavingsPlansUtilizationDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Queries for available tag keys and tag values for a specified period. You can search the tag values for an arbitrary string.
     */
    override suspend fun getTags(input: GetTagsRequest): GetTagsResponse {
        val op = SdkHttpOperation.build<GetTagsRequest, GetTagsResponse> {
            serializer = GetTagsOperationSerializer()
            deserializer = GetTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage.
     */
    override suspend fun getUsageForecast(input: GetUsageForecastRequest): GetUsageForecastResponse {
        val op = SdkHttpOperation.build<GetUsageForecastRequest, GetUsageForecastResponse> {
            serializer = GetUsageForecastOperationSerializer()
            deserializer = GetUsageForecastOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsageForecast"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of cost allocation tags. All inputs in the API are optional and serve as filters. By default, all cost allocation tags are returned.
     */
    override suspend fun listCostAllocationTags(input: ListCostAllocationTagsRequest): ListCostAllocationTagsResponse {
        val op = SdkHttpOperation.build<ListCostAllocationTagsRequest, ListCostAllocationTagsResponse> {
            serializer = ListCostAllocationTagsOperationSerializer()
            deserializer = ListCostAllocationTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCostAllocationTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the name, Amazon Resource Name (ARN), `NumberOfRules` and effective dates of all Cost Categories defined in the account. You have the option to use `EffectiveOn` to return a list of Cost Categories that were active on a specific date. If there is no `EffectiveOn` specified, you’ll see Cost Categories that are effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response. `ListCostCategoryDefinitions` supports pagination. The request can have a `MaxResults` range up to 100.
     */
    override suspend fun listCostCategoryDefinitions(input: ListCostCategoryDefinitionsRequest): ListCostCategoryDefinitionsResponse {
        val op = SdkHttpOperation.build<ListCostCategoryDefinitionsRequest, ListCostCategoryDefinitionsResponse> {
            serializer = ListCostCategoryDefinitionsOperationSerializer()
            deserializer = ListCostCategoryDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCostCategoryDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the feedback property of a given cost anomaly.
     */
    override suspend fun provideAnomalyFeedback(input: ProvideAnomalyFeedbackRequest): ProvideAnomalyFeedbackResponse {
        val op = SdkHttpOperation.build<ProvideAnomalyFeedbackRequest, ProvideAnomalyFeedbackResponse> {
            serializer = ProvideAnomalyFeedbackOperationSerializer()
            deserializer = ProvideAnomalyFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvideAnomalyFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     *
     * You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value you specify replaces the previous value for that tag.
     *
     * Although the maximum number of array members is 200, user-tag maximum is 50. The remaining are reserved for Amazon Web Services use.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn't change anomalies detected in the past.
     */
    override suspend fun updateAnomalyMonitor(input: UpdateAnomalyMonitorRequest): UpdateAnomalyMonitorResponse {
        val op = SdkHttpOperation.build<UpdateAnomalyMonitorRequest, UpdateAnomalyMonitorResponse> {
            serializer = UpdateAnomalyMonitorOperationSerializer()
            deserializer = UpdateAnomalyMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAnomalyMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing cost anomaly monitor subscription.
     */
    override suspend fun updateAnomalySubscription(input: UpdateAnomalySubscriptionRequest): UpdateAnomalySubscriptionResponse {
        val op = SdkHttpOperation.build<UpdateAnomalySubscriptionRequest, UpdateAnomalySubscriptionResponse> {
            serializer = UpdateAnomalySubscriptionOperationSerializer()
            deserializer = UpdateAnomalySubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAnomalySubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates status for cost allocation tags in bulk, with maximum batch size of 20. If the tag status that's updated is the same as the existing tag status, the request doesn't fail. Instead, it doesn't have any effect on the tag status (for example, activating the active tag).
     */
    override suspend fun updateCostAllocationTagsStatus(input: UpdateCostAllocationTagsStatusRequest): UpdateCostAllocationTagsStatusResponse {
        val op = SdkHttpOperation.build<UpdateCostAllocationTagsStatusRequest, UpdateCostAllocationTagsStatusResponse> {
            serializer = UpdateCostAllocationTagsStatusOperationSerializer()
            deserializer = UpdateCostAllocationTagsStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCostAllocationTagsStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.
     */
    override suspend fun updateCostCategoryDefinition(input: UpdateCostCategoryDefinitionRequest): UpdateCostCategoryDefinitionResponse {
        val op = SdkHttpOperation.build<UpdateCostCategoryDefinitionRequest, UpdateCostCategoryDefinitionResponse> {
            serializer = UpdateCostCategoryDefinitionOperationSerializer()
            deserializer = UpdateCostCategoryDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCostCategoryDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSInsightsIndexService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ce"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "ce")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
