// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costexplorer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.costexplorer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.costexplorer.model.*
import aws.sdk.kotlin.services.costexplorer.model.CreateAnomalyMonitorRequest
import aws.sdk.kotlin.services.costexplorer.model.CreateAnomalyMonitorResponse
import aws.sdk.kotlin.services.costexplorer.model.CreateAnomalySubscriptionRequest
import aws.sdk.kotlin.services.costexplorer.model.CreateAnomalySubscriptionResponse
import aws.sdk.kotlin.services.costexplorer.model.CreateCostCategoryDefinitionRequest
import aws.sdk.kotlin.services.costexplorer.model.CreateCostCategoryDefinitionResponse
import aws.sdk.kotlin.services.costexplorer.model.DeleteAnomalyMonitorRequest
import aws.sdk.kotlin.services.costexplorer.model.DeleteAnomalyMonitorResponse
import aws.sdk.kotlin.services.costexplorer.model.DeleteAnomalySubscriptionRequest
import aws.sdk.kotlin.services.costexplorer.model.DeleteAnomalySubscriptionResponse
import aws.sdk.kotlin.services.costexplorer.model.DeleteCostCategoryDefinitionRequest
import aws.sdk.kotlin.services.costexplorer.model.DeleteCostCategoryDefinitionResponse
import aws.sdk.kotlin.services.costexplorer.model.DescribeCostCategoryDefinitionRequest
import aws.sdk.kotlin.services.costexplorer.model.DescribeCostCategoryDefinitionResponse
import aws.sdk.kotlin.services.costexplorer.model.GetAnomaliesRequest
import aws.sdk.kotlin.services.costexplorer.model.GetAnomaliesResponse
import aws.sdk.kotlin.services.costexplorer.model.GetAnomalyMonitorsRequest
import aws.sdk.kotlin.services.costexplorer.model.GetAnomalyMonitorsResponse
import aws.sdk.kotlin.services.costexplorer.model.GetAnomalySubscriptionsRequest
import aws.sdk.kotlin.services.costexplorer.model.GetAnomalySubscriptionsResponse
import aws.sdk.kotlin.services.costexplorer.model.GetCostAndUsageRequest
import aws.sdk.kotlin.services.costexplorer.model.GetCostAndUsageResponse
import aws.sdk.kotlin.services.costexplorer.model.GetCostAndUsageWithResourcesRequest
import aws.sdk.kotlin.services.costexplorer.model.GetCostAndUsageWithResourcesResponse
import aws.sdk.kotlin.services.costexplorer.model.GetCostCategoriesRequest
import aws.sdk.kotlin.services.costexplorer.model.GetCostCategoriesResponse
import aws.sdk.kotlin.services.costexplorer.model.GetCostForecastRequest
import aws.sdk.kotlin.services.costexplorer.model.GetCostForecastResponse
import aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesRequest
import aws.sdk.kotlin.services.costexplorer.model.GetDimensionValuesResponse
import aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageRequest
import aws.sdk.kotlin.services.costexplorer.model.GetReservationCoverageResponse
import aws.sdk.kotlin.services.costexplorer.model.GetReservationPurchaseRecommendationRequest
import aws.sdk.kotlin.services.costexplorer.model.GetReservationPurchaseRecommendationResponse
import aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationRequest
import aws.sdk.kotlin.services.costexplorer.model.GetReservationUtilizationResponse
import aws.sdk.kotlin.services.costexplorer.model.GetRightsizingRecommendationRequest
import aws.sdk.kotlin.services.costexplorer.model.GetRightsizingRecommendationResponse
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageRequest
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansCoverageResponse
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationRequest
import aws.sdk.kotlin.services.costexplorer.model.GetSavingsPlansUtilizationResponse
import aws.sdk.kotlin.services.costexplorer.model.GetTagsRequest
import aws.sdk.kotlin.services.costexplorer.model.GetTagsResponse
import aws.sdk.kotlin.services.costexplorer.model.GetUsageForecastRequest
import aws.sdk.kotlin.services.costexplorer.model.GetUsageForecastResponse
import aws.sdk.kotlin.services.costexplorer.model.ListCostAllocationTagsRequest
import aws.sdk.kotlin.services.costexplorer.model.ListCostAllocationTagsResponse
import aws.sdk.kotlin.services.costexplorer.model.ListCostCategoryDefinitionsRequest
import aws.sdk.kotlin.services.costexplorer.model.ListCostCategoryDefinitionsResponse
import aws.sdk.kotlin.services.costexplorer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.costexplorer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.costexplorer.model.ProvideAnomalyFeedbackRequest
import aws.sdk.kotlin.services.costexplorer.model.ProvideAnomalyFeedbackResponse
import aws.sdk.kotlin.services.costexplorer.model.TagResourceRequest
import aws.sdk.kotlin.services.costexplorer.model.TagResourceResponse
import aws.sdk.kotlin.services.costexplorer.model.UntagResourceRequest
import aws.sdk.kotlin.services.costexplorer.model.UntagResourceResponse
import aws.sdk.kotlin.services.costexplorer.model.UpdateAnomalyMonitorRequest
import aws.sdk.kotlin.services.costexplorer.model.UpdateAnomalyMonitorResponse
import aws.sdk.kotlin.services.costexplorer.model.UpdateAnomalySubscriptionRequest
import aws.sdk.kotlin.services.costexplorer.model.UpdateAnomalySubscriptionResponse
import aws.sdk.kotlin.services.costexplorer.model.UpdateCostAllocationTagsStatusRequest
import aws.sdk.kotlin.services.costexplorer.model.UpdateCostAllocationTagsStatusResponse
import aws.sdk.kotlin.services.costexplorer.model.UpdateCostCategoryDefinitionRequest
import aws.sdk.kotlin.services.costexplorer.model.UpdateCostCategoryDefinitionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * You can use the Cost Explorer API to programmatically query your cost and usage data. You can query for aggregated data such as total monthly costs or total daily usage. You can also query for granular data. This might include the number of daily write operations for Amazon DynamoDB database tables in your production environment.
 *
 * Service Endpoint
 *
 * The Cost Explorer API provides the following endpoint:
 * + `https://ce.us-east-1.amazonaws.com`
 *
 * For information about the costs that are associated with the Cost Explorer API, see [Amazon Web Services Cost Management Pricing](http://aws.amazon.com/aws-cost-management/pricing/).
 */
public interface CostExplorerClient : SdkClient {

    override val serviceName: String
        get() = "Cost Explorer"
    /**
     * CostExplorerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CostExplorerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCostExplorerClient(config)
        }

        public operator fun invoke(config: Config): CostExplorerClient = DefaultCostExplorerClient(config)

        /**
         * Construct a [CostExplorerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CostExplorerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCostExplorerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
     */
    public suspend fun createAnomalyMonitor(input: CreateAnomalyMonitorRequest): CreateAnomalyMonitorResponse

    /**
     * Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving notifications.
     */
    public suspend fun createAnomalySubscription(input: CreateAnomalySubscriptionRequest): CreateAnomalySubscriptionResponse

    /**
     * Creates a new Cost Category with the requested name and rules.
     */
    public suspend fun createCostCategoryDefinition(input: CreateCostCategoryDefinitionRequest): CreateCostCategoryDefinitionResponse

    /**
     * Deletes a cost anomaly monitor.
     */
    public suspend fun deleteAnomalyMonitor(input: DeleteAnomalyMonitorRequest): DeleteAnomalyMonitorResponse

    /**
     * Deletes a cost anomaly subscription.
     */
    public suspend fun deleteAnomalySubscription(input: DeleteAnomalySubscriptionRequest): DeleteAnomalySubscriptionResponse

    /**
     * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost Category.
     */
    public suspend fun deleteCostCategoryDefinition(input: DeleteCostCategoryDefinitionRequest): DeleteCostCategoryDefinitionResponse

    /**
     * Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's defined in the account.
     *
     * You have the option to use `EffectiveOn` to return a Cost Category that's active on a specific date. If there's no `EffectiveOn` specified, you see a Cost Category that's effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response.
     */
    public suspend fun describeCostCategoryDefinition(input: DescribeCostCategoryDefinitionRequest): DescribeCostCategoryDefinitionResponse

    /**
     * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the `DateInterval` object.
     */
    public suspend fun getAnomalies(input: GetAnomaliesRequest): GetAnomaliesResponse

    /**
     * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
     */
    public suspend fun getAnomalyMonitors(input: GetAnomalyMonitorsRequest = GetAnomalyMonitorsRequest {}): GetAnomalyMonitorsResponse

    /**
     * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
     */
    public suspend fun getAnomalySubscriptions(input: GetAnomalySubscriptionsRequest = GetAnomalySubscriptionsRequest {}): GetAnomalySubscriptionsResponse

    /**
     * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you want the request to return. For example, you can specify `BlendedCosts` or `UsageQuantity`. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [GetDimensionValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html) operation. Management account in an organization in Organizations have access to all member accounts.
     *
     * For information about filter limitations, see [Quotas and restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html) in the *Billing and Cost Management User Guide*.
     */
    public suspend fun getCostAndUsage(input: GetCostAndUsageRequest): GetCostAndUsageResponse

    /**
     * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related metric, such as `BlendedCosts` or `UsageQuantity`, that you want the request to return. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [GetDimensionValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html) operation. Management account in an organization in Organizations have access to all member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
     *
     * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information about how to access the Settings page, see [Controlling Access for Cost Explorer](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html) in the *Billing and Cost Management User Guide*.
     */
    public suspend fun getCostAndUsageWithResources(input: GetCostAndUsageWithResourcesRequest): GetCostAndUsageWithResourcesResponse

    /**
     * Retrieves an array of Cost Category names and values incurred cost.
     *
     * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
     */
    public suspend fun getCostCategories(input: GetCostCategoriesRequest): GetCostCategoriesResponse

    /**
     * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs.
     */
    public suspend fun getCostForecast(input: GetCostForecastRequest): GetCostForecastResponse

    /**
     * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension values for an arbitrary string.
     */
    public suspend fun getDimensionValues(input: GetDimensionValuesRequest): GetDimensionValuesResponse

    /**
     * Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a reservation. An organization's management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about reservation usage by the following dimensions:
     * + AZ
     * + CACHE_ENGINE
     * + DATABASE_ENGINE
     * + DEPLOYMENT_OPTION
     * + INSTANCE_TYPE
     * + LINKED_ACCOUNT
     * + OPERATING_SYSTEM
     * + PLATFORM
     * + REGION
     * + SERVICE
     * + TAG
     * + TENANCY
     *
     * To determine valid values for a dimension, use the `GetDimensionValues` operation.
     */
    public suspend fun getReservationCoverage(input: GetReservationCoverageRequest): GetReservationCoverageResponse

    /**
     * Gets recommendations for reservation purchases. These recommendations might help you to reduce your costs. Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
     *
     * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services has these categories, it simulates every combination of reservations in each category of usage to identify the best number of each type of Reserved Instance (RI) to purchase to maximize your estimated savings.
     *
     * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes it easier to purchase a size-flexible Reserved Instance (RI). Amazon Web Services also shows the equal number of normalized units. This way, you can purchase any instance size that you want. For this example, your RI recommendation is for `c4.large` because that is the smallest size instance in the c4 instance family.
     */
    public suspend fun getReservationPurchaseRecommendation(input: GetReservationPurchaseRecommendationRequest): GetReservationPurchaseRecommendationResponse

    /**
     * Retrieves the reservation utilization for your account. Management account in an organization have access to member accounts. You can filter data by dimensions in a time period. You can use `GetDimensionValues` to determine the possible dimension values. Currently, you can group only by `SUBSCRIPTION_ID`.
     */
    public suspend fun getReservationUtilization(input: GetReservationUtilizationRequest): GetReservationUtilizationResponse

    /**
     * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
     *
     * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and metrics. For more information about calculation and function, see [Optimizing Your Cost with Rightsizing Recommendations](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html) in the *Billing and Cost Management User Guide*.
     */
    public suspend fun getRightsizingRecommendation(input: GetRightsizingRecommendationRequest): GetRightsizingRecommendationResponse

    /**
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for Savings Plans usage with the following dimensions:
     * + `LINKED_ACCOUNT`
     * + `REGION`
     * + `SERVICE`
     * + `INSTANCE_FAMILY`
     *
     * To determine valid values for a dimension, use the `GetDimensionValues` operation.
     */
    public suspend fun getSavingsPlansCoverage(input: GetSavingsPlansCoverageRequest): GetSavingsPlansCoverageResponse

    /**
     * Retrieves your request parameters, Savings Plan Recommendations Summary and Details.
     */
    public suspend fun getSavingsPlansPurchaseRecommendation(input: GetSavingsPlansPurchaseRecommendationRequest): GetSavingsPlansPurchaseRecommendationResponse

    /**
     * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use `GetDimensionValues` in `SAVINGS_PLANS` to determine the possible dimension values.
     *
     * You can't group by any dimension values for `GetSavingsPlansUtilization`.
     */
    public suspend fun getSavingsPlansUtilization(input: GetSavingsPlansUtilizationRequest): GetSavingsPlansUtilizationResponse

    /**
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to `GetSavingsPlanUtilization`, but you have the option to make multiple calls to `GetSavingsPlanUtilizationDetails` by providing individual dates. You can use `GetDimensionValues` in `SAVINGS_PLANS` to determine the possible dimension values.
     *
     * `GetSavingsPlanUtilizationDetails` internally groups data by `SavingsPlansArn`.
     */
    public suspend fun getSavingsPlansUtilizationDetails(input: GetSavingsPlansUtilizationDetailsRequest): GetSavingsPlansUtilizationDetailsResponse

    /**
     * Queries for available tag keys and tag values for a specified period. You can search the tag values for an arbitrary string.
     */
    public suspend fun getTags(input: GetTagsRequest): GetTagsResponse

    /**
     * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage.
     */
    public suspend fun getUsageForecast(input: GetUsageForecastRequest): GetUsageForecastResponse

    /**
     * Get a list of cost allocation tags. All inputs in the API are optional and serve as filters. By default, all cost allocation tags are returned.
     */
    public suspend fun listCostAllocationTags(input: ListCostAllocationTagsRequest = ListCostAllocationTagsRequest {}): ListCostAllocationTagsResponse

    /**
     * Returns the name, Amazon Resource Name (ARN), `NumberOfRules` and effective dates of all Cost Categories defined in the account. You have the option to use `EffectiveOn` to return a list of Cost Categories that were active on a specific date. If there is no `EffectiveOn` specified, you’ll see Cost Categories that are effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response. `ListCostCategoryDefinitions` supports pagination. The request can have a `MaxResults` range up to 100.
     */
    public suspend fun listCostCategoryDefinitions(input: ListCostCategoryDefinitionsRequest = ListCostCategoryDefinitionsRequest {}): ListCostCategoryDefinitionsResponse

    /**
     * Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Modifies the feedback property of a given cost anomaly.
     */
    public suspend fun provideAnomalyFeedback(input: ProvideAnomalyFeedbackRequest): ProvideAnomalyFeedbackResponse

    /**
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     *
     * You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value you specify replaces the previous value for that tag.
     *
     * Although the maximum number of array members is 200, user-tag maximum is 50. The remaining are reserved for Amazon Web Services use.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn't change anomalies detected in the past.
     */
    public suspend fun updateAnomalyMonitor(input: UpdateAnomalyMonitorRequest): UpdateAnomalyMonitorResponse

    /**
     * Updates an existing cost anomaly monitor subscription.
     */
    public suspend fun updateAnomalySubscription(input: UpdateAnomalySubscriptionRequest): UpdateAnomalySubscriptionResponse

    /**
     * Updates status for cost allocation tags in bulk, with maximum batch size of 20. If the tag status that's updated is the same as the existing tag status, the request doesn't fail. Instead, it doesn't have any effect on the tag status (for example, activating the active tag).
     */
    public suspend fun updateCostAllocationTagsStatus(input: UpdateCostAllocationTagsStatusRequest): UpdateCostAllocationTagsStatusResponse

    /**
     * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.
     */
    public suspend fun updateCostCategoryDefinition(input: UpdateCostCategoryDefinitionRequest): UpdateCostCategoryDefinitionResponse
}

/**
 * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
 */
public suspend inline fun CostExplorerClient.createAnomalyMonitor(crossinline block: CreateAnomalyMonitorRequest.Builder.() -> Unit): CreateAnomalyMonitorResponse = createAnomalyMonitor(CreateAnomalyMonitorRequest.Builder().apply(block).build())

/**
 * Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving notifications.
 */
public suspend inline fun CostExplorerClient.createAnomalySubscription(crossinline block: CreateAnomalySubscriptionRequest.Builder.() -> Unit): CreateAnomalySubscriptionResponse = createAnomalySubscription(CreateAnomalySubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a new Cost Category with the requested name and rules.
 */
public suspend inline fun CostExplorerClient.createCostCategoryDefinition(crossinline block: CreateCostCategoryDefinitionRequest.Builder.() -> Unit): CreateCostCategoryDefinitionResponse = createCostCategoryDefinition(CreateCostCategoryDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a cost anomaly monitor.
 */
public suspend inline fun CostExplorerClient.deleteAnomalyMonitor(crossinline block: DeleteAnomalyMonitorRequest.Builder.() -> Unit): DeleteAnomalyMonitorResponse = deleteAnomalyMonitor(DeleteAnomalyMonitorRequest.Builder().apply(block).build())

/**
 * Deletes a cost anomaly subscription.
 */
public suspend inline fun CostExplorerClient.deleteAnomalySubscription(crossinline block: DeleteAnomalySubscriptionRequest.Builder.() -> Unit): DeleteAnomalySubscriptionResponse = deleteAnomalySubscription(DeleteAnomalySubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost Category.
 */
public suspend inline fun CostExplorerClient.deleteCostCategoryDefinition(crossinline block: DeleteCostCategoryDefinitionRequest.Builder.() -> Unit): DeleteCostCategoryDefinitionResponse = deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest.Builder().apply(block).build())

/**
 * Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's defined in the account.
 *
 * You have the option to use `EffectiveOn` to return a Cost Category that's active on a specific date. If there's no `EffectiveOn` specified, you see a Cost Category that's effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response.
 */
public suspend inline fun CostExplorerClient.describeCostCategoryDefinition(crossinline block: DescribeCostCategoryDefinitionRequest.Builder.() -> Unit): DescribeCostCategoryDefinitionResponse = describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the `DateInterval` object.
 */
public suspend inline fun CostExplorerClient.getAnomalies(crossinline block: GetAnomaliesRequest.Builder.() -> Unit): GetAnomaliesResponse = getAnomalies(GetAnomaliesRequest.Builder().apply(block).build())

/**
 * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
 */
public suspend inline fun CostExplorerClient.getAnomalyMonitors(crossinline block: GetAnomalyMonitorsRequest.Builder.() -> Unit): GetAnomalyMonitorsResponse = getAnomalyMonitors(GetAnomalyMonitorsRequest.Builder().apply(block).build())

/**
 * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
 */
public suspend inline fun CostExplorerClient.getAnomalySubscriptions(crossinline block: GetAnomalySubscriptionsRequest.Builder.() -> Unit): GetAnomalySubscriptionsResponse = getAnomalySubscriptions(GetAnomalySubscriptionsRequest.Builder().apply(block).build())

/**
 * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you want the request to return. For example, you can specify `BlendedCosts` or `UsageQuantity`. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [GetDimensionValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html) operation. Management account in an organization in Organizations have access to all member accounts.
 *
 * For information about filter limitations, see [Quotas and restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html) in the *Billing and Cost Management User Guide*.
 */
public suspend inline fun CostExplorerClient.getCostAndUsage(crossinline block: GetCostAndUsageRequest.Builder.() -> Unit): GetCostAndUsageResponse = getCostAndUsage(GetCostAndUsageRequest.Builder().apply(block).build())

/**
 * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related metric, such as `BlendedCosts` or `UsageQuantity`, that you want the request to return. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [GetDimensionValues](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html) operation. Management account in an organization in Organizations have access to all member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
 *
 * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information about how to access the Settings page, see [Controlling Access for Cost Explorer](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html) in the *Billing and Cost Management User Guide*.
 */
public suspend inline fun CostExplorerClient.getCostAndUsageWithResources(crossinline block: GetCostAndUsageWithResourcesRequest.Builder.() -> Unit): GetCostAndUsageWithResourcesResponse = getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest.Builder().apply(block).build())

/**
 * Retrieves an array of Cost Category names and values incurred cost.
 *
 * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
 */
public suspend inline fun CostExplorerClient.getCostCategories(crossinline block: GetCostCategoriesRequest.Builder.() -> Unit): GetCostCategoriesResponse = getCostCategories(GetCostCategoriesRequest.Builder().apply(block).build())

/**
 * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs.
 */
public suspend inline fun CostExplorerClient.getCostForecast(crossinline block: GetCostForecastRequest.Builder.() -> Unit): GetCostForecastResponse = getCostForecast(GetCostForecastRequest.Builder().apply(block).build())

/**
 * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension values for an arbitrary string.
 */
public suspend inline fun CostExplorerClient.getDimensionValues(crossinline block: GetDimensionValuesRequest.Builder.() -> Unit): GetDimensionValuesResponse = getDimensionValues(GetDimensionValuesRequest.Builder().apply(block).build())

/**
 * Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a reservation. An organization's management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about reservation usage by the following dimensions:
 * + AZ
 * + CACHE_ENGINE
 * + DATABASE_ENGINE
 * + DEPLOYMENT_OPTION
 * + INSTANCE_TYPE
 * + LINKED_ACCOUNT
 * + OPERATING_SYSTEM
 * + PLATFORM
 * + REGION
 * + SERVICE
 * + TAG
 * + TENANCY
 *
 * To determine valid values for a dimension, use the `GetDimensionValues` operation.
 */
public suspend inline fun CostExplorerClient.getReservationCoverage(crossinline block: GetReservationCoverageRequest.Builder.() -> Unit): GetReservationCoverageResponse = getReservationCoverage(GetReservationCoverageRequest.Builder().apply(block).build())

/**
 * Gets recommendations for reservation purchases. These recommendations might help you to reduce your costs. Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
 *
 * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services has these categories, it simulates every combination of reservations in each category of usage to identify the best number of each type of Reserved Instance (RI) to purchase to maximize your estimated savings.
 *
 * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes it easier to purchase a size-flexible Reserved Instance (RI). Amazon Web Services also shows the equal number of normalized units. This way, you can purchase any instance size that you want. For this example, your RI recommendation is for `c4.large` because that is the smallest size instance in the c4 instance family.
 */
public suspend inline fun CostExplorerClient.getReservationPurchaseRecommendation(crossinline block: GetReservationPurchaseRecommendationRequest.Builder.() -> Unit): GetReservationPurchaseRecommendationResponse = getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest.Builder().apply(block).build())

/**
 * Retrieves the reservation utilization for your account. Management account in an organization have access to member accounts. You can filter data by dimensions in a time period. You can use `GetDimensionValues` to determine the possible dimension values. Currently, you can group only by `SUBSCRIPTION_ID`.
 */
public suspend inline fun CostExplorerClient.getReservationUtilization(crossinline block: GetReservationUtilizationRequest.Builder.() -> Unit): GetReservationUtilizationResponse = getReservationUtilization(GetReservationUtilizationRequest.Builder().apply(block).build())

/**
 * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
 *
 * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and metrics. For more information about calculation and function, see [Optimizing Your Cost with Rightsizing Recommendations](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html) in the *Billing and Cost Management User Guide*.
 */
public suspend inline fun CostExplorerClient.getRightsizingRecommendation(crossinline block: GetRightsizingRecommendationRequest.Builder.() -> Unit): GetRightsizingRecommendationResponse = getRightsizingRecommendation(GetRightsizingRecommendationRequest.Builder().apply(block).build())

/**
 * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for Savings Plans usage with the following dimensions:
 * + `LINKED_ACCOUNT`
 * + `REGION`
 * + `SERVICE`
 * + `INSTANCE_FAMILY`
 *
 * To determine valid values for a dimension, use the `GetDimensionValues` operation.
 */
public suspend inline fun CostExplorerClient.getSavingsPlansCoverage(crossinline block: GetSavingsPlansCoverageRequest.Builder.() -> Unit): GetSavingsPlansCoverageResponse = getSavingsPlansCoverage(GetSavingsPlansCoverageRequest.Builder().apply(block).build())

/**
 * Retrieves your request parameters, Savings Plan Recommendations Summary and Details.
 */
public suspend inline fun CostExplorerClient.getSavingsPlansPurchaseRecommendation(crossinline block: GetSavingsPlansPurchaseRecommendationRequest.Builder.() -> Unit): GetSavingsPlansPurchaseRecommendationResponse = getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest.Builder().apply(block).build())

/**
 * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use `GetDimensionValues` in `SAVINGS_PLANS` to determine the possible dimension values.
 *
 * You can't group by any dimension values for `GetSavingsPlansUtilization`.
 */
public suspend inline fun CostExplorerClient.getSavingsPlansUtilization(crossinline block: GetSavingsPlansUtilizationRequest.Builder.() -> Unit): GetSavingsPlansUtilizationResponse = getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest.Builder().apply(block).build())

/**
 * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to `GetSavingsPlanUtilization`, but you have the option to make multiple calls to `GetSavingsPlanUtilizationDetails` by providing individual dates. You can use `GetDimensionValues` in `SAVINGS_PLANS` to determine the possible dimension values.
 *
 * `GetSavingsPlanUtilizationDetails` internally groups data by `SavingsPlansArn`.
 */
public suspend inline fun CostExplorerClient.getSavingsPlansUtilizationDetails(crossinline block: GetSavingsPlansUtilizationDetailsRequest.Builder.() -> Unit): GetSavingsPlansUtilizationDetailsResponse = getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest.Builder().apply(block).build())

/**
 * Queries for available tag keys and tag values for a specified period. You can search the tag values for an arbitrary string.
 */
public suspend inline fun CostExplorerClient.getTags(crossinline block: GetTagsRequest.Builder.() -> Unit): GetTagsResponse = getTags(GetTagsRequest.Builder().apply(block).build())

/**
 * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage.
 */
public suspend inline fun CostExplorerClient.getUsageForecast(crossinline block: GetUsageForecastRequest.Builder.() -> Unit): GetUsageForecastResponse = getUsageForecast(GetUsageForecastRequest.Builder().apply(block).build())

/**
 * Get a list of cost allocation tags. All inputs in the API are optional and serve as filters. By default, all cost allocation tags are returned.
 */
public suspend inline fun CostExplorerClient.listCostAllocationTags(crossinline block: ListCostAllocationTagsRequest.Builder.() -> Unit): ListCostAllocationTagsResponse = listCostAllocationTags(ListCostAllocationTagsRequest.Builder().apply(block).build())

/**
 * Returns the name, Amazon Resource Name (ARN), `NumberOfRules` and effective dates of all Cost Categories defined in the account. You have the option to use `EffectiveOn` to return a list of Cost Categories that were active on a specific date. If there is no `EffectiveOn` specified, you’ll see Cost Categories that are effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response. `ListCostCategoryDefinitions` supports pagination. The request can have a `MaxResults` range up to 100.
 */
public suspend inline fun CostExplorerClient.listCostCategoryDefinitions(crossinline block: ListCostCategoryDefinitionsRequest.Builder.() -> Unit): ListCostCategoryDefinitionsResponse = listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest.Builder().apply(block).build())

/**
 * Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN).
 */
public suspend inline fun CostExplorerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Modifies the feedback property of a given cost anomaly.
 */
public suspend inline fun CostExplorerClient.provideAnomalyFeedback(crossinline block: ProvideAnomalyFeedbackRequest.Builder.() -> Unit): ProvideAnomalyFeedbackResponse = provideAnomalyFeedback(ProvideAnomalyFeedbackRequest.Builder().apply(block).build())

/**
 * An API operation for adding one or more tags (key-value pairs) to a resource.
 *
 * You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value you specify replaces the previous value for that tag.
 *
 * Although the maximum number of array members is 200, user-tag maximum is 50. The remaining are reserved for Amazon Web Services use.
 */
public suspend inline fun CostExplorerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
 */
public suspend inline fun CostExplorerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn't change anomalies detected in the past.
 */
public suspend inline fun CostExplorerClient.updateAnomalyMonitor(crossinline block: UpdateAnomalyMonitorRequest.Builder.() -> Unit): UpdateAnomalyMonitorResponse = updateAnomalyMonitor(UpdateAnomalyMonitorRequest.Builder().apply(block).build())

/**
 * Updates an existing cost anomaly monitor subscription.
 */
public suspend inline fun CostExplorerClient.updateAnomalySubscription(crossinline block: UpdateAnomalySubscriptionRequest.Builder.() -> Unit): UpdateAnomalySubscriptionResponse = updateAnomalySubscription(UpdateAnomalySubscriptionRequest.Builder().apply(block).build())

/**
 * Updates status for cost allocation tags in bulk, with maximum batch size of 20. If the tag status that's updated is the same as the existing tag status, the request doesn't fail. Instead, it doesn't have any effect on the tag status (for example, activating the active tag).
 */
public suspend inline fun CostExplorerClient.updateCostAllocationTagsStatus(crossinline block: UpdateCostAllocationTagsStatusRequest.Builder.() -> Unit): UpdateCostAllocationTagsStatusResponse = updateCostAllocationTagsStatus(UpdateCostAllocationTagsStatusRequest.Builder().apply(block).build())

/**
 * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.
 */
public suspend inline fun CostExplorerClient.updateCostCategoryDefinition(crossinline block: UpdateCostCategoryDefinitionRequest.Builder.() -> Unit): UpdateCostCategoryDefinitionResponse = updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest.Builder().apply(block).build())
