// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costandusagereportservice.model



/**
 * The definition of AWS Cost and Usage Report. You can specify the report name, time unit, report format, compression format, S3 bucket, additional artifacts, and schema elements in the definition.
 */
public class ReportDefinition private constructor(builder: Builder) {
    /**
     * A list of manifests that you want Amazon Web Services to create for this report.
     */
    public val additionalArtifacts: List<AdditionalArtifact>? = builder.additionalArtifacts
    /**
     * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
     */
    public val additionalSchemaElements: List<SchemaElement>? = builder.additionalSchemaElements
    /**
     * The Amazon resource name of the billing view. You can get this value by using the billing view service public APIs.
     */
    public val billingViewArn: kotlin.String? = builder.billingViewArn
    /**
     * The compression format that AWS uses for the report.
     */
    public val compression: aws.sdk.kotlin.services.costandusagereportservice.model.CompressionFormat? = builder.compression
    /**
     * The format that AWS saves the report in.
     */
    public val format: aws.sdk.kotlin.services.costandusagereportservice.model.ReportFormat? = builder.format
    /**
     * Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months. These charges can include refunds, credits, or support fees.
     */
    public val refreshClosedReports: kotlin.Boolean? = builder.refreshClosedReports
    /**
     * The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces.
     */
    public val reportName: kotlin.String? = builder.reportName
    /**
     * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
     */
    public val reportVersioning: aws.sdk.kotlin.services.costandusagereportservice.model.ReportVersioning? = builder.reportVersioning
    /**
     * The S3 bucket where AWS delivers the report.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The prefix that AWS adds to the report name when AWS delivers the report. Your prefix can't include spaces.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * The region of the S3 bucket that AWS delivers the report into.
     */
    public val s3Region: aws.sdk.kotlin.services.costandusagereportservice.model.AwsRegion? = builder.s3Region
    /**
     * The length of time covered by the report.
     */
    public val timeUnit: aws.sdk.kotlin.services.costandusagereportservice.model.TimeUnit? = builder.timeUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.costandusagereportservice.model.ReportDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportDefinition(")
        append("additionalArtifacts=$additionalArtifacts,")
        append("additionalSchemaElements=$additionalSchemaElements,")
        append("billingViewArn=$billingViewArn,")
        append("compression=$compression,")
        append("format=$format,")
        append("refreshClosedReports=$refreshClosedReports,")
        append("reportName=$reportName,")
        append("reportVersioning=$reportVersioning,")
        append("s3Bucket=$s3Bucket,")
        append("s3Prefix=$s3Prefix,")
        append("s3Region=$s3Region,")
        append("timeUnit=$timeUnit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalArtifacts?.hashCode() ?: 0
        result = 31 * result + (additionalSchemaElements?.hashCode() ?: 0)
        result = 31 * result + (billingViewArn?.hashCode() ?: 0)
        result = 31 * result + (compression?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (refreshClosedReports?.hashCode() ?: 0)
        result = 31 * result + (reportName?.hashCode() ?: 0)
        result = 31 * result + (reportVersioning?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (s3Region?.hashCode() ?: 0)
        result = 31 * result + (timeUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportDefinition

        if (additionalArtifacts != other.additionalArtifacts) return false
        if (additionalSchemaElements != other.additionalSchemaElements) return false
        if (billingViewArn != other.billingViewArn) return false
        if (compression != other.compression) return false
        if (format != other.format) return false
        if (refreshClosedReports != other.refreshClosedReports) return false
        if (reportName != other.reportName) return false
        if (reportVersioning != other.reportVersioning) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Prefix != other.s3Prefix) return false
        if (s3Region != other.s3Region) return false
        if (timeUnit != other.timeUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.costandusagereportservice.model.ReportDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of manifests that you want Amazon Web Services to create for this report.
         */
        public var additionalArtifacts: List<AdditionalArtifact>? = null
        /**
         * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
         */
        public var additionalSchemaElements: List<SchemaElement>? = null
        /**
         * The Amazon resource name of the billing view. You can get this value by using the billing view service public APIs.
         */
        public var billingViewArn: kotlin.String? = null
        /**
         * The compression format that AWS uses for the report.
         */
        public var compression: aws.sdk.kotlin.services.costandusagereportservice.model.CompressionFormat? = null
        /**
         * The format that AWS saves the report in.
         */
        public var format: aws.sdk.kotlin.services.costandusagereportservice.model.ReportFormat? = null
        /**
         * Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months. These charges can include refunds, credits, or support fees.
         */
        public var refreshClosedReports: kotlin.Boolean? = null
        /**
         * The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces.
         */
        public var reportName: kotlin.String? = null
        /**
         * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
         */
        public var reportVersioning: aws.sdk.kotlin.services.costandusagereportservice.model.ReportVersioning? = null
        /**
         * The S3 bucket where AWS delivers the report.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The prefix that AWS adds to the report name when AWS delivers the report. Your prefix can't include spaces.
         */
        public var s3Prefix: kotlin.String? = null
        /**
         * The region of the S3 bucket that AWS delivers the report into.
         */
        public var s3Region: aws.sdk.kotlin.services.costandusagereportservice.model.AwsRegion? = null
        /**
         * The length of time covered by the report.
         */
        public var timeUnit: aws.sdk.kotlin.services.costandusagereportservice.model.TimeUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.costandusagereportservice.model.ReportDefinition) : this() {
            this.additionalArtifacts = x.additionalArtifacts
            this.additionalSchemaElements = x.additionalSchemaElements
            this.billingViewArn = x.billingViewArn
            this.compression = x.compression
            this.format = x.format
            this.refreshClosedReports = x.refreshClosedReports
            this.reportName = x.reportName
            this.reportVersioning = x.reportVersioning
            this.s3Bucket = x.s3Bucket
            this.s3Prefix = x.s3Prefix
            this.s3Region = x.s3Region
            this.timeUnit = x.timeUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.costandusagereportservice.model.ReportDefinition = ReportDefinition(this)
    }
}
