// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costandusagereportservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.costandusagereportservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.costandusagereportservice.model.*
import aws.sdk.kotlin.services.costandusagereportservice.model.DeleteReportDefinitionRequest
import aws.sdk.kotlin.services.costandusagereportservice.model.DeleteReportDefinitionResponse
import aws.sdk.kotlin.services.costandusagereportservice.model.DescribeReportDefinitionsRequest
import aws.sdk.kotlin.services.costandusagereportservice.model.DescribeReportDefinitionsResponse
import aws.sdk.kotlin.services.costandusagereportservice.model.ModifyReportDefinitionRequest
import aws.sdk.kotlin.services.costandusagereportservice.model.ModifyReportDefinitionResponse
import aws.sdk.kotlin.services.costandusagereportservice.model.PutReportDefinitionRequest
import aws.sdk.kotlin.services.costandusagereportservice.model.PutReportDefinitionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The AWS Cost and Usage Report API enables you to programmatically create, query, and delete AWS Cost and Usage report definitions.
 *
 * AWS Cost and Usage reports track the monthly AWS costs and usage associated with your AWS account. The report contains line items for each unique combination of AWS product, usage type, and operation that your AWS account uses. You can configure the AWS Cost and Usage report to show only the data that you want, using the AWS Cost and Usage API.
 *
 * Service Endpoint
 *
 * The AWS Cost and Usage Report API provides the following endpoint:
 * + cur.us-east-1.amazonaws.com
 */
public interface CostAndUsageReportClient : SdkClient {

    override val serviceName: String
        get() = "Cost and Usage Report Service"
    /**
     * CostAndUsageReportClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CostAndUsageReportClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCostAndUsageReportClient(config)
        }

        public operator fun invoke(config: Config): CostAndUsageReportClient = DefaultCostAndUsageReportClient(config)

        /**
         * Construct a [CostAndUsageReportClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CostAndUsageReportClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCostAndUsageReportClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified report.
     */
    public suspend fun deleteReportDefinition(input: DeleteReportDefinitionRequest = DeleteReportDefinitionRequest {}): DeleteReportDefinitionResponse

    /**
     * Lists the AWS Cost and Usage reports available to this account.
     */
    public suspend fun describeReportDefinitions(input: DescribeReportDefinitionsRequest = DescribeReportDefinitionsRequest {}): DescribeReportDefinitionsResponse

    /**
     * Allows you to programatically update your report preferences.
     */
    public suspend fun modifyReportDefinition(input: ModifyReportDefinitionRequest): ModifyReportDefinitionResponse

    /**
     * Creates a new report using the description that you provide.
     */
    public suspend fun putReportDefinition(input: PutReportDefinitionRequest): PutReportDefinitionResponse
}

/**
 * Deletes the specified report.
 */
public suspend inline fun CostAndUsageReportClient.deleteReportDefinition(crossinline block: DeleteReportDefinitionRequest.Builder.() -> Unit): DeleteReportDefinitionResponse = deleteReportDefinition(DeleteReportDefinitionRequest.Builder().apply(block).build())

/**
 * Lists the AWS Cost and Usage reports available to this account.
 */
public suspend inline fun CostAndUsageReportClient.describeReportDefinitions(crossinline block: DescribeReportDefinitionsRequest.Builder.() -> Unit): DescribeReportDefinitionsResponse = describeReportDefinitions(DescribeReportDefinitionsRequest.Builder().apply(block).build())

/**
 * Allows you to programatically update your report preferences.
 */
public suspend inline fun CostAndUsageReportClient.modifyReportDefinition(crossinline block: ModifyReportDefinitionRequest.Builder.() -> Unit): ModifyReportDefinitionResponse = modifyReportDefinition(ModifyReportDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a new report using the description that you provide.
 */
public suspend inline fun CostAndUsageReportClient.putReportDefinition(crossinline block: PutReportDefinitionRequest.Builder.() -> Unit): PutReportDefinitionResponse = putReportDefinition(PutReportDefinitionRequest.Builder().apply(block).build())
