// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.controlcatalog.paginators

import aws.sdk.kotlin.services.controlcatalog.ControlCatalogClient
import aws.sdk.kotlin.services.controlcatalog.model.CommonControlSummary
import aws.sdk.kotlin.services.controlcatalog.model.DomainSummary
import aws.sdk.kotlin.services.controlcatalog.model.ListCommonControlsRequest
import aws.sdk.kotlin.services.controlcatalog.model.ListCommonControlsResponse
import aws.sdk.kotlin.services.controlcatalog.model.ListDomainsRequest
import aws.sdk.kotlin.services.controlcatalog.model.ListDomainsResponse
import aws.sdk.kotlin.services.controlcatalog.model.ListObjectivesRequest
import aws.sdk.kotlin.services.controlcatalog.model.ListObjectivesResponse
import aws.sdk.kotlin.services.controlcatalog.model.ObjectiveSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCommonControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCommonControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCommonControlsResponse]
 */
public fun ControlCatalogClient.listCommonControlsPaginated(initialRequest: ListCommonControlsRequest = ListCommonControlsRequest { }): Flow<ListCommonControlsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCommonControlsPaginated.listCommonControls(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCommonControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCommonControlsResponse]
 */
public fun ControlCatalogClient.listCommonControlsPaginated(block: ListCommonControlsRequest.Builder.() -> Unit): Flow<ListCommonControlsResponse> =
    listCommonControlsPaginated(ListCommonControlsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCommonControlsPaginated]
 * to access the nested member [CommonControlSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CommonControlSummary]
 */
@JvmName("listCommonControlsResponseCommonControlSummary")
public fun Flow<ListCommonControlsResponse>.commonControls(): Flow<CommonControlSummary> =
    transform() { response ->
        response.commonControls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun ControlCatalogClient.listDomainsPaginated(initialRequest: ListDomainsRequest = ListDomainsRequest { }): Flow<ListDomainsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsPaginated.listDomains(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun ControlCatalogClient.listDomainsPaginated(block: ListDomainsRequest.Builder.() -> Unit): Flow<ListDomainsResponse> =
    listDomainsPaginated(ListDomainsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainsPaginated]
 * to access the nested member [DomainSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainSummary]
 */
@JvmName("listDomainsResponseDomainSummary")
public fun Flow<ListDomainsResponse>.domains(): Flow<DomainSummary> =
    transform() { response ->
        response.domains?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListObjectivesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListObjectivesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectivesResponse]
 */
public fun ControlCatalogClient.listObjectivesPaginated(initialRequest: ListObjectivesRequest = ListObjectivesRequest { }): Flow<ListObjectivesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listObjectivesPaginated.listObjectives(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListObjectivesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectivesResponse]
 */
public fun ControlCatalogClient.listObjectivesPaginated(block: ListObjectivesRequest.Builder.() -> Unit): Flow<ListObjectivesResponse> =
    listObjectivesPaginated(ListObjectivesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listObjectivesPaginated]
 * to access the nested member [ObjectiveSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ObjectiveSummary]
 */
@JvmName("listObjectivesResponseObjectiveSummary")
public fun Flow<ListObjectivesResponse>.objectives(): Flow<ObjectiveSummary> =
    transform() { response ->
        response.objectives?.forEach {
            emit(it)
        }
    }
